/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.io.compress;

import java.util.zip.ZipEntry;
import org.miaixz.bus.core.lang.exception.ValidateException;

public class ZipSecurity {
    public static ZipEntry checkZipBomb(ZipEntry entry, int maxSizeDiff) {
        if (null == entry) {
            return null;
        }
        if (maxSizeDiff < 0 || entry.isDirectory()) {
            return entry;
        }
        long compressedSize = entry.getCompressedSize();
        long uncompressedSize = entry.getSize();
        if (compressedSize < 0L || uncompressedSize < 0L || compressedSize * (long)maxSizeDiff < uncompressedSize) {
            throw new ValidateException("Zip bomb attack detected, invalid sizes: compressed {}, uncompressed {}, name {}", compressedSize, uncompressedSize, entry.getName());
        }
        return entry;
    }
}

