/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.io.resource;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import org.miaixz.bus.core.io.resource.Resource;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.ByteKit;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.core.xyz.StringKit;

public class CharSequenceResource
implements Resource,
Serializable {
    private static final long serialVersionUID = -1L;
    private final CharSequence data;
    private final CharSequence name;
    private final Charset charset;

    public CharSequenceResource(CharSequence data) {
        this(data, null);
    }

    public CharSequenceResource(CharSequence data, String name) {
        this(data, name, org.miaixz.bus.core.lang.Charset.UTF_8);
    }

    public CharSequenceResource(CharSequence data, CharSequence name, Charset charset) {
        this.data = data;
        this.name = name;
        this.charset = charset;
    }

    @Override
    public String getName() {
        return StringKit.toString(this.name);
    }

    @Override
    public URL getUrl() {
        return null;
    }

    @Override
    public long size() {
        return this.data.length();
    }

    @Override
    public InputStream getStream() {
        return new ByteArrayInputStream(this.readBytes());
    }

    @Override
    public BufferedReader getReader(Charset charset) {
        return IoKit.toBuffered(new StringReader(this.data.toString()));
    }

    @Override
    public String readString(Charset charset) throws InternalException {
        return this.data.toString();
    }

    @Override
    public byte[] readBytes() throws InternalException {
        return ByteKit.toBytes(this.data, this.charset);
    }
}

