/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.io.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;
import org.miaixz.bus.core.io.resource.Resource;
import org.miaixz.bus.core.io.stream.ReaderInputStream;
import org.miaixz.bus.core.lang.exception.InternalException;

public class InputStreamResource
implements Resource,
Serializable {
    private static final long serialVersionUID = -1L;
    private final InputStream in;
    private final String name;

    public InputStreamResource(Reader reader, Charset charset) {
        this(new ReaderInputStream(reader, charset));
    }

    public InputStreamResource(InputStream in) {
        this(in, null);
    }

    public InputStreamResource(InputStream in, String name) {
        this.in = in;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URL getUrl() {
        return null;
    }

    @Override
    public long size() {
        try {
            return this.in.available();
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    @Override
    public InputStream getStream() {
        return this.in;
    }
}

