/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.io.resource;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.IoKit;

public interface Resource {
    public String getName();

    public URL getUrl();

    public long size();

    public InputStream getStream();

    default public boolean isModified() {
        return false;
    }

    default public void writeTo(OutputStream out) throws InternalException {
        try (InputStream in = this.getStream();){
            IoKit.copy(in, out);
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    default public BufferedReader getReader(Charset charset) {
        return IoKit.toReader(this.getStream(), charset);
    }

    default public String readString(Charset charset) throws InternalException {
        return IoKit.read(this.getReader(charset));
    }

    default public String readString() throws InternalException {
        return this.readString(org.miaixz.bus.core.lang.Charset.UTF_8);
    }

    default public byte[] readBytes() throws InternalException {
        return IoKit.readBytes(this.getStream());
    }
}

