/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.lang.loader.classloader;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.miaixz.bus.core.io.file.FileName;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.ClassKit;
import org.miaixz.bus.core.xyz.FileKit;
import org.miaixz.bus.core.xyz.MethodKit;
import org.miaixz.bus.core.xyz.UrlKit;

public class JarClassLoader
extends URLClassLoader {
    public JarClassLoader() {
        this(new URL[0]);
    }

    public JarClassLoader(URL[] urls) {
        super(urls, ClassKit.getClassLoader());
    }

    public JarClassLoader(URL[] urls, ClassLoader classLoader) {
        super(urls, classLoader);
    }

    public static JarClassLoader load(File dir) {
        JarClassLoader loader = new JarClassLoader();
        loader.addJar(dir);
        loader.addURL(dir);
        return loader;
    }

    public static JarClassLoader loadJar(File jarFile) {
        JarClassLoader loader = new JarClassLoader();
        loader.addJar(jarFile);
        return loader;
    }

    public static void loadJar(URLClassLoader loader, File jarFile) throws InternalException {
        try {
            Method method = MethodKit.getMethod(URLClassLoader.class, "addURL", URL.class);
            if (null != method) {
                List<File> jars = JarClassLoader.loopJar(jarFile);
                for (File jar : jars) {
                    MethodKit.invoke((Object)loader, method, jar.toURI().toURL());
                }
            }
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    public static URLClassLoader loadJarToSystemClassLoader(File jarFile) {
        URLClassLoader urlClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        JarClassLoader.loadJar(urlClassLoader, jarFile);
        return urlClassLoader;
    }

    private static List<File> loopJar(File file) {
        return FileKit.loopFiles(file, JarClassLoader::isJarFile);
    }

    private static boolean isJarFile(File file) {
        return FileKit.isFile(file) && FileName.isType(file.getName(), "jar");
    }

    public JarClassLoader addJar(File jarFileOrDir) {
        List<File> jars = JarClassLoader.loopJar(jarFileOrDir);
        for (File jar : jars) {
            this.addURL(jar);
        }
        return this;
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    public JarClassLoader addURL(File dir) {
        super.addURL(UrlKit.getURL(dir));
        return this;
    }
}

