/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.lang.mutable;

import org.miaixz.bus.core.lang.mutable.Mutable;
import org.miaixz.bus.core.xyz.CompareKit;

public class MutableFloat
extends Number
implements Comparable<MutableFloat>,
Mutable<Number> {
    private static final long serialVersionUID = -1L;
    private float value;

    public MutableFloat() {
    }

    public MutableFloat(float value) {
        this.value = value;
    }

    public MutableFloat(Number value) {
        this(value.floatValue());
    }

    public MutableFloat(String value) throws NumberFormatException {
        this.value = Float.parseFloat(value);
    }

    @Override
    public Float get() {
        return Float.valueOf(this.value);
    }

    @Override
    public void set(float value) {
        this.value = value;
    }

    @Override
    public void set(Number value) {
        this.value = value.floatValue();
    }

    public MutableFloat increment() {
        this.value += 1.0f;
        return this;
    }

    public MutableFloat decrement() {
        this.value -= 1.0f;
        return this;
    }

    public MutableFloat add(float operand) {
        this.value += operand;
        return this;
    }

    public MutableFloat add(Number operand) {
        this.value += operand.floatValue();
        return this;
    }

    public MutableFloat subtract(float operand) {
        this.value -= operand;
        return this;
    }

    public MutableFloat subtract(Number operand) {
        this.value -= operand.floatValue();
        return this;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MutableFloat) {
            return Float.floatToIntBits(((MutableFloat)obj).value) == Float.floatToIntBits(this.value);
        }
        return false;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.value);
    }

    @Override
    public int compareTo(MutableFloat other) {
        return CompareKit.compare(this.value, other.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

