/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.lang.pool.partition;

import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.lang.pool.ObjectFactory;
import org.miaixz.bus.core.lang.pool.ObjectPool;
import org.miaixz.bus.core.lang.pool.PoolConfig;
import org.miaixz.bus.core.lang.pool.Poolable;
import org.miaixz.bus.core.lang.pool.partition.PartitionPoolable;

public class PoolPartition<T>
implements ObjectPool<T> {
    private static final long serialVersionUID = -1L;
    private final PoolConfig config;
    private final ObjectFactory<T> objectFactory;
    private BlockingQueue<Poolable<T>> queue;
    private int total;

    public PoolPartition(PoolConfig config, BlockingQueue<Poolable<T>> queue, ObjectFactory<T> objectFactory) {
        this.config = config;
        this.queue = queue;
        this.objectFactory = objectFactory;
        int minSize = config.getMinSize();
        for (int i = 0; i < minSize; ++i) {
            queue.add(this.createPoolable());
        }
        this.total = minSize;
    }

    @Override
    public Poolable<T> borrowObject() {
        Poolable<T> poolable = (Poolable<T>)this.queue.poll();
        if (null != poolable) {
            long maxIdle;
            if (this.objectFactory.validate(poolable.getRaw()) && ((maxIdle = this.config.getMaxIdle()) <= 0L || System.currentTimeMillis() - poolable.getLastBorrow() <= maxIdle)) {
                poolable.setLastBorrow(System.currentTimeMillis());
                return poolable;
            }
            this.free(poolable);
            return this.borrowObject();
        }
        if (this.increase(1) <= 0 && null == (poolable = this.waitingPoll())) {
            throw new InternalException("Pool exhausted!");
        }
        return this.borrowObject();
    }

    @Override
    public PoolPartition<T> returnObject(Poolable<T> poolable) {
        if (this.objectFactory.validate(poolable.getRaw())) {
            try {
                this.queue.put(poolable);
            }
            catch (InterruptedException e) {
                throw new InternalException(e);
            }
        } else {
            this.free(poolable);
        }
        return this;
    }

    public synchronized int increase(int increaseSize) {
        if (increaseSize + this.total > this.config.getMaxSize()) {
            increaseSize = this.config.getMaxSize() - this.total;
        }
        try {
            for (int i = 0; i < increaseSize; ++i) {
                this.queue.put(this.createPoolable());
            }
            this.total += increaseSize;
        }
        catch (InterruptedException e) {
            throw new InternalException(e);
        }
        return increaseSize;
    }

    public synchronized PoolPartition<T> free(Poolable<T> obj) {
        this.objectFactory.destroy(obj.getRaw());
        --this.total;
        return this;
    }

    @Override
    public int getTotal() {
        return this.total;
    }

    @Override
    public int getIdleCount() {
        return this.queue.size();
    }

    @Override
    public int getActiveCount() {
        return this.getTotal() - this.getIdleCount();
    }

    @Override
    public void close() throws IOException {
        this.queue.forEach(this::free);
        this.queue.clear();
        this.queue = null;
    }

    protected Poolable<T> createPoolable() {
        T t = this.objectFactory.create();
        if (t instanceof Poolable) {
            return (Poolable)t;
        }
        return new PartitionPoolable<T>(this.objectFactory.create(), this);
    }

    private Poolable<T> waitingPoll() throws InternalException {
        long maxWait = this.config.getMaxWait();
        try {
            if (maxWait <= 0L) {
                return this.queue.take();
            }
            return this.queue.poll(maxWait, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new InternalException(e);
        }
    }
}

