/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.lang.range;

import java.util.Objects;
import org.miaixz.bus.core.lang.Optional;
import org.miaixz.bus.core.lang.range.Bound;
import org.miaixz.bus.core.lang.range.BoundedRange;
import org.miaixz.bus.core.xyz.CompareKit;

public class BoundedRangeOperation {
    public static <T extends Comparable<? super T>> BoundedRange<T> unionIfIntersected(BoundedRange<T> boundedRange, BoundedRange<T> other) {
        Objects.requireNonNull(boundedRange);
        Objects.requireNonNull(other);
        if (BoundedRangeOperation.isDisjoint(boundedRange, other)) {
            return boundedRange;
        }
        return new BoundedRange<T>(CompareKit.min(boundedRange.getLowerBound(), other.getLowerBound()), CompareKit.max(boundedRange.getUpperBound(), other.getUpperBound()));
    }

    public static <T extends Comparable<? super T>> BoundedRange<T> span(BoundedRange<T> boundedRange, BoundedRange<T> other) {
        Objects.requireNonNull(boundedRange);
        Objects.requireNonNull(other);
        return new BoundedRange<T>(CompareKit.min(boundedRange.getLowerBound(), other.getLowerBound()), CompareKit.max(boundedRange.getUpperBound(), other.getUpperBound()));
    }

    public static <T extends Comparable<? super T>> BoundedRange<T> gap(BoundedRange<T> boundedRange, BoundedRange<T> other) {
        Objects.requireNonNull(boundedRange);
        Objects.requireNonNull(other);
        if (BoundedRangeOperation.isIntersected(boundedRange, other)) {
            return null;
        }
        return new BoundedRange(CompareKit.min(boundedRange.getUpperBound(), other.getUpperBound()).negate(), CompareKit.max(boundedRange.getLowerBound(), other.getLowerBound()).negate());
    }

    public static <T extends Comparable<? super T>> BoundedRange<T> intersection(BoundedRange<T> boundedRange, BoundedRange<T> other) {
        Objects.requireNonNull(boundedRange);
        Objects.requireNonNull(other);
        if (BoundedRangeOperation.isDisjoint(boundedRange, other)) {
            return null;
        }
        return new BoundedRange<T>(CompareKit.max(boundedRange.getLowerBound(), other.getLowerBound()), CompareKit.min(boundedRange.getUpperBound(), other.getUpperBound()));
    }

    public static <T extends Comparable<? super T>> BoundedRange<T> subGreatThan(BoundedRange<T> boundedRange, T min) {
        return Optional.ofNullable(min).filter(boundedRange).map(t -> new BoundedRange<Comparable>(Bound.greaterThan(t), boundedRange.getUpperBound())).orElse(boundedRange);
    }

    public static <T extends Comparable<? super T>> BoundedRange<T> subAtLeast(BoundedRange<T> boundedRange, T min) {
        return Optional.ofNullable(min).filter(boundedRange).map(t -> new BoundedRange<Comparable>(Bound.atLeast(t), boundedRange.getUpperBound())).orElse(boundedRange);
    }

    public static <T extends Comparable<? super T>> BoundedRange<T> subLessThan(BoundedRange<T> boundedRange, T max) {
        return Optional.ofNullable(max).filter(boundedRange).map(t -> new BoundedRange<Comparable>(boundedRange.getLowerBound(), Bound.lessThan(max))).orElse(boundedRange);
    }

    public static <T extends Comparable<? super T>> BoundedRange<T> subAtMost(BoundedRange<T> boundedRange, T max) {
        return Optional.ofNullable(max).filter(boundedRange).map(t -> new BoundedRange<Comparable>(boundedRange.getLowerBound(), Bound.atMost(max))).orElse(boundedRange);
    }

    public static <T extends Comparable<? super T>> boolean isIntersected(BoundedRange<T> boundedRange, BoundedRange<T> other) {
        return !BoundedRangeOperation.isDisjoint(boundedRange, other);
    }

    public static <T extends Comparable<? super T>> boolean isDisjoint(BoundedRange<T> boundedRange, BoundedRange<T> other) {
        Objects.requireNonNull(boundedRange);
        Objects.requireNonNull(other);
        return boundedRange.getLowerBound().compareTo(other.getUpperBound()) > 0 || boundedRange.getUpperBound().compareTo(other.getLowerBound()) < 0;
    }
}

