/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.lang.reflect.creator;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.reflect.creator.DefaultObjectCreator;
import org.miaixz.bus.core.lang.reflect.creator.ObjectCreator;
import org.miaixz.bus.core.xyz.ClassKit;
import org.miaixz.bus.core.xyz.ReflectKit;

public class PossibleObjectCreator<T>
implements ObjectCreator<T> {
    final Class<T> clazz;

    public PossibleObjectCreator(Class<T> clazz) {
        this.clazz = Assert.notNull(clazz);
    }

    public static <T> PossibleObjectCreator<T> of(Class<T> clazz) {
        return new PossibleObjectCreator<T>(clazz);
    }

    private static Class<?> resolveType(Class<?> type) {
        if (type.isAssignableFrom(AbstractMap.class)) {
            return HashMap.class;
        }
        if (type.isAssignableFrom(List.class)) {
            return ArrayList.class;
        }
        if (type == SortedSet.class) {
            return TreeSet.class;
        }
        if (type.isAssignableFrom(Set.class)) {
            return HashSet.class;
        }
        return type;
    }

    @Override
    public T create() {
        Class<T> type = this.clazz;
        if (type.isPrimitive()) {
            return (T)ClassKit.getPrimitiveDefaultValue(type);
        }
        type = PossibleObjectCreator.resolveType(type);
        try {
            return DefaultObjectCreator.of(type, new Object[0]).create();
        }
        catch (Exception exception) {
            Constructor<T>[] constructors;
            if (type.isEnum()) {
                return type.getEnumConstants()[0];
            }
            if (type.isArray()) {
                return (T)Array.newInstance(type.getComponentType(), 0);
            }
            for (Constructor<T> constructor : constructors = ReflectKit.getConstructors(type)) {
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                if (0 == parameterTypes.length) continue;
                ReflectKit.setAccessible(constructor);
                try {
                    return constructor.newInstance(ClassKit.getDefaultValues(parameterTypes));
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            return null;
        }
    }
}

