/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.math;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.math.ChineseNumberFormatter;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.MathKit;
import org.miaixz.bus.core.xyz.StringKit;

public class ChineseNumberParser {
    private static final ChineseUnit[] CHINESE_NAME_VALUE = new ChineseUnit[]{new ChineseUnit(' ', 1, false), new ChineseUnit('\u5341', 10, false), new ChineseUnit('\u62fe', 10, false), new ChineseUnit('\u767e', 100, false), new ChineseUnit('\u4f70', 100, false), new ChineseUnit('\u5343', 1000, false), new ChineseUnit('\u4edf', 1000, false), new ChineseUnit('\u4e07', 10000, true), new ChineseUnit('\u4ebf', 100000000, true)};

    public static BigDecimal parseFromChinese(String chinese) {
        if (StringKit.containsAny((CharSequence)chinese, '\u5143', '\u5706', '\u89d2', '\u5206')) {
            return ChineseNumberParser.parseFromChineseMoney(chinese);
        }
        return ChineseNumberParser.parseFromChineseNumber(chinese);
    }

    public static BigDecimal parseFromChineseNumber(String chinese) {
        Assert.notBlank(chinese, "Chinese number is blank!", new Object[0]);
        int dotIndex = chinese.indexOf(28857);
        BigDecimal result = MathKit.toBigDecimal(ChineseNumberParser.parseLongFromChineseNumber(chinese, dotIndex > 0 ? dotIndex : chinese.length()));
        if (dotIndex > 0) {
            int length = chinese.length();
            for (int i = dotIndex + 1; i < length; ++i) {
                result = result.add(MathKit.div(ChineseNumberParser.chineseToNumber(chinese.charAt(i)), BigDecimal.TEN.pow(i - dotIndex), length - dotIndex + 1));
            }
        }
        return result.stripTrailingZeros();
    }

    public static BigDecimal parseFromChineseMoney(String chineseMoneyAmount) {
        if (StringKit.isBlank(chineseMoneyAmount)) {
            return null;
        }
        int yi = chineseMoneyAmount.indexOf("\u5143");
        if (yi == -1) {
            yi = chineseMoneyAmount.indexOf("\u5706");
        }
        int ji = chineseMoneyAmount.indexOf("\u89d2");
        int fi = chineseMoneyAmount.indexOf("\u5206");
        String yStr = null;
        if (yi > 0) {
            yStr = chineseMoneyAmount.substring(0, yi);
        }
        String jStr = null;
        if (ji > 0) {
            if (yi >= 0) {
                if (ji > yi) {
                    jStr = chineseMoneyAmount.substring(yi + 1, ji);
                }
            } else {
                jStr = chineseMoneyAmount.substring(0, ji);
            }
        }
        String fStr = null;
        if (fi > 0) {
            if (ji >= 0) {
                if (fi > ji) {
                    fStr = chineseMoneyAmount.substring(ji + 1, fi);
                }
            } else if (yi > 0) {
                if (fi > yi) {
                    fStr = chineseMoneyAmount.substring(yi + 1, fi);
                }
            } else {
                fStr = chineseMoneyAmount.substring(0, fi);
            }
        }
        long y = 0L;
        long j = 0L;
        long f = 0L;
        if (StringKit.isNotBlank(yStr)) {
            y = ChineseNumberParser.parseLongFromChineseNumber(yStr, yStr.length());
        }
        if (StringKit.isNotBlank(jStr)) {
            j = ChineseNumberParser.parseLongFromChineseNumber(jStr, jStr.length());
        }
        if (StringKit.isNotBlank(fStr)) {
            f = ChineseNumberParser.parseLongFromChineseNumber(fStr, fStr.length());
        }
        BigDecimal amount = new BigDecimal(y);
        amount = amount.add(BigDecimal.valueOf(j).divide(BigDecimal.TEN, 2, RoundingMode.HALF_UP));
        amount = amount.add(BigDecimal.valueOf(f).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP));
        return amount;
    }

    public static long parseLongFromChineseNumber(String chinese, int toIndex) {
        long result = 0L;
        long section = 0L;
        long number = 0L;
        ChineseUnit unit = null;
        for (int i = 0; i < toIndex; ++i) {
            char c = chinese.charAt(i);
            int num = ChineseNumberParser.chineseToNumber(c);
            if (num >= 0) {
                if (num == 0) {
                    if (number > 0L && null != unit) {
                        section += number * (long)(unit.value / 10);
                    }
                    unit = null;
                } else if (number > 0L) {
                    throw new IllegalArgumentException(StringKit.format("Bad number '{}{}' at: {}", Character.valueOf(chinese.charAt(i - 1)), Character.valueOf(c), i));
                }
                number = num;
                continue;
            }
            unit = ChineseNumberParser.chineseToUnit(c);
            if (null == unit) {
                throw new IllegalArgumentException(StringKit.format("Unknown unit '{}' at: {}", Character.valueOf(c), i));
            }
            if (unit.secUnit) {
                section = (section + number) * (long)unit.value;
                result += section;
                section = 0L;
            } else {
                long unitNumber = number;
                if (0L == number && 0 == i) {
                    unitNumber = 1L;
                }
                section += unitNumber * (long)unit.value;
            }
            number = 0L;
        }
        if (number > 0L && null != unit) {
            number *= (long)(unit.value / 10);
        }
        return result + section + number;
    }

    private static ChineseUnit chineseToUnit(char chinese) {
        for (ChineseUnit chineseNameValue : CHINESE_NAME_VALUE) {
            if (chineseNameValue.name != chinese) continue;
            return chineseNameValue;
        }
        return null;
    }

    private static int chineseToNumber(char chinese) {
        int i;
        if ('\u4e24' == chinese) {
            chinese = (char)20108;
        }
        if ((i = ArrayKit.indexOf(ChineseNumberFormatter.DIGITS, chinese)) > 0) {
            return (i + 1) / 2;
        }
        return i;
    }

    static String getUnitName(int index, boolean isUseTraditional) {
        if (0 == index) {
            return "";
        }
        return String.valueOf(ChineseNumberParser.CHINESE_NAME_VALUE[index * 2 - (isUseTraditional ? 0 : 1)].name);
    }

    private static class ChineseUnit {
        private final char name;
        private final int value;
        private final boolean secUnit;

        public ChineseUnit(char name, int value, boolean secUnit) {
            this.name = name;
            this.value = value;
            this.secUnit = secUnit;
        }
    }
}

