/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.net.url;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.nio.charset.Charset;
import org.miaixz.bus.core.Builder;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.net.url.RFC3986;
import org.miaixz.bus.core.net.url.UrlPath;
import org.miaixz.bus.core.net.url.UrlQuery;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.core.xyz.UrlKit;

public final class UrlBuilder
implements Builder<String> {
    private static final long serialVersionUID = -1L;
    private final boolean needEncodePercent;
    private String scheme;
    private String host;
    private int port = -1;
    private UrlPath path;
    private UrlQuery query;
    private String fragment;
    private Charset charset;

    public UrlBuilder() {
        this.charset = org.miaixz.bus.core.lang.Charset.UTF_8;
        this.needEncodePercent = true;
    }

    public UrlBuilder(String scheme, String host, int port, UrlPath path, UrlQuery query, String fragment, Charset charset) {
        this.charset = charset;
        this.scheme = scheme;
        this.host = host;
        this.port = port;
        this.path = path;
        this.query = query;
        this.setFragment(fragment);
        this.needEncodePercent = null != charset;
    }

    public static UrlBuilder of(UrlBuilder builder) {
        return UrlBuilder.of(builder.getScheme(), builder.getHost(), builder.getPort(), builder.getPaths(), builder.getQuerys(), builder.getFragment(), builder.getCharset());
    }

    public static UrlBuilder of(URI uri, Charset charset) {
        return UrlBuilder.of(uri.getScheme(), uri.getHost(), uri.getPort(), uri.getPath(), uri.getRawQuery(), uri.getFragment(), charset);
    }

    public static UrlBuilder ofHttpWithoutEncode(String httpUrl) {
        return UrlBuilder.ofHttp(httpUrl, null);
    }

    public static UrlBuilder ofHttp(String httpUrl) {
        return UrlBuilder.ofHttp(httpUrl, org.miaixz.bus.core.lang.Charset.UTF_8);
    }

    public static UrlBuilder ofHttp(String httpUrl, Charset charset) {
        Assert.notBlank(httpUrl, "Protocol url must be not blank!", new Object[0]);
        httpUrl = StringKit.trimPrefix((CharSequence)httpUrl);
        if (!StringKit.startWithAnyIgnoreCase((CharSequence)httpUrl, "http://", "https://")) {
            httpUrl = "http://" + (String)httpUrl;
        }
        return UrlBuilder.of(UrlKit.toUrlForHttp((String)httpUrl), charset);
    }

    public static UrlBuilder of(String url) {
        return UrlBuilder.of(url, org.miaixz.bus.core.lang.Charset.UTF_8);
    }

    public static UrlBuilder of(String url, Charset charset) {
        Assert.notBlank(url, "Url must be not blank!", new Object[0]);
        return UrlBuilder.of(UrlKit.url(StringKit.trim(url)), charset);
    }

    public static UrlBuilder of(URL url, Charset charset) {
        return UrlBuilder.of(url.getProtocol(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef(), charset);
    }

    public static UrlBuilder of(String scheme, String host, int port, String path, String query, String fragment, Charset charset) {
        return UrlBuilder.of(scheme, host, port, UrlPath.of(path, charset), UrlQuery.of(query, charset, false), fragment, charset);
    }

    public static UrlBuilder of(String scheme, String host, int port, UrlPath path, UrlQuery query, String fragment, Charset charset) {
        return new UrlBuilder(scheme, host, port, path, query, fragment, charset);
    }

    public static UrlBuilder of() {
        return new UrlBuilder();
    }

    public String getScheme() {
        return this.scheme;
    }

    public UrlBuilder setScheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public String getSchemeWithDefault() {
        return StringKit.defaultIfEmpty(this.scheme, "http");
    }

    public String getHost() {
        return this.host;
    }

    public UrlBuilder setHost(String host) {
        this.host = host;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public UrlBuilder setPort(int port) {
        this.port = port;
        return this;
    }

    public int getPortWithDefault() {
        int port = this.getPort();
        if (port <= 0) {
            port = this.toURL().getDefaultPort();
            return port;
        }
        return port;
    }

    public String getAuthority() {
        return this.port < 0 ? this.host : this.host + ":" + this.port;
    }

    public UrlPath getPath() {
        return this.path;
    }

    public UrlBuilder setPath(UrlPath path) {
        this.path = path;
        return this;
    }

    public String getPaths() {
        return null == this.path ? "/" : this.path.build(this.charset, this.needEncodePercent);
    }

    public UrlBuilder addPath(CharSequence path) {
        UrlPath.of(path, this.charset).getSegments().forEach(this::addPathSegment);
        return this;
    }

    public UrlBuilder setWithEndTag(boolean withEngTag) {
        if (null == this.path) {
            this.path = UrlPath.of();
        }
        this.path.setWithEndTag(withEngTag);
        return this;
    }

    public UrlBuilder addPathSegment(CharSequence segment) {
        if (StringKit.isEmpty(segment)) {
            return this;
        }
        if (null == this.path) {
            this.path = new UrlPath();
        }
        this.path.add(segment);
        return this;
    }

    public UrlQuery getQuery() {
        return this.query;
    }

    public UrlBuilder setQuery(UrlQuery query) {
        this.query = query;
        return this;
    }

    public String getQuerys() {
        return null == this.query ? null : this.query.build(this.charset, this.needEncodePercent);
    }

    public UrlBuilder addQuery(String key, Object value) {
        if (StringKit.isEmpty(key)) {
            return this;
        }
        if (this.query == null) {
            this.query = UrlQuery.of();
        }
        this.query.add(key, value);
        return this;
    }

    public String getFragment() {
        return this.fragment;
    }

    public UrlBuilder setFragment(String fragment) {
        if (StringKit.isEmpty(fragment)) {
            this.fragment = null;
        }
        this.fragment = StringKit.removePrefix(fragment, "#");
        return this;
    }

    public String getFragmentEncoded() {
        char[] cArray;
        if (this.needEncodePercent) {
            cArray = null;
        } else {
            char[] cArray2 = new char[1];
            cArray = cArray2;
            cArray2[0] = 37;
        }
        char[] safeChars = cArray;
        return RFC3986.FRAGMENT.encode(this.fragment, this.charset, safeChars);
    }

    public Charset getCharset() {
        return this.charset;
    }

    public UrlBuilder setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    @Override
    public String build() {
        return this.toURL().toString();
    }

    public URL toURL() {
        return this.toURL(null);
    }

    public URL toURL(URLStreamHandler handler) {
        StringBuilder fileBuilder = new StringBuilder();
        fileBuilder.append(this.getPaths());
        String query = this.getQuerys();
        if (StringKit.isNotBlank(query)) {
            fileBuilder.append('?').append(query);
        }
        if (StringKit.isNotBlank(this.fragment)) {
            fileBuilder.append('#').append(this.getFragmentEncoded());
        }
        try {
            return new URL(this.getSchemeWithDefault(), this.host, this.port, fileBuilder.toString(), handler);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public URI toURI() {
        try {
            return this.toURL().toURI();
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public String toString() {
        return this.build();
    }
}

