/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.text;

import org.miaixz.bus.core.xyz.CharKit;
import org.miaixz.bus.core.xyz.StringKit;

public class NamingCase {
    public static String toUnderlineCase(CharSequence text) {
        return NamingCase.toSymbolCase(text, '_');
    }

    public static String toKebabCase(CharSequence text) {
        return NamingCase.toSymbolCase(text, '-');
    }

    public static String toSymbolCase(CharSequence text, char symbol) {
        if (text == null) {
            return null;
        }
        int length = text.length();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            if (Character.isUpperCase(c)) {
                Character nextChar;
                Character preChar = i > 0 ? Character.valueOf(text.charAt(i - 1)) : null;
                Character c2 = nextChar = i < text.length() - 1 ? Character.valueOf(text.charAt(i + 1)) : null;
                if (null != preChar) {
                    if (symbol == preChar.charValue()) {
                        if (null == nextChar || Character.isLowerCase(nextChar.charValue())) {
                            c = Character.toLowerCase(c);
                        }
                    } else if (Character.isLowerCase(preChar.charValue())) {
                        sb.append(symbol);
                        if (null == nextChar || Character.isLowerCase(nextChar.charValue()) || CharKit.isNumber(nextChar.charValue())) {
                            c = Character.toLowerCase(c);
                        }
                    } else if (null != nextChar && Character.isLowerCase(nextChar.charValue())) {
                        sb.append(symbol);
                        c = Character.toLowerCase(c);
                    }
                } else if (null == nextChar || Character.isLowerCase(nextChar.charValue())) {
                    c = Character.toLowerCase(c);
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String toPascalCase(CharSequence name) {
        return StringKit.upperFirst(NamingCase.toCamelCase(name));
    }

    public static String toCamelCase(CharSequence name) {
        return NamingCase.toCamelCase(name, '_');
    }

    public static String toCamelCase(CharSequence name, char symbol) {
        return NamingCase.toCamelCase(name, symbol, true);
    }

    public static String toCamelCase(CharSequence name, char symbol, boolean otherCharToLower) {
        if (null == name) {
            return null;
        }
        String name2 = name.toString();
        if (StringKit.contains((CharSequence)name2, symbol)) {
            int length = name2.length();
            StringBuilder sb = new StringBuilder(length);
            boolean upperCase = false;
            for (int i = 0; i < length; ++i) {
                char c = name2.charAt(i);
                if (c == symbol) {
                    upperCase = true;
                    continue;
                }
                if (upperCase) {
                    sb.append(Character.toUpperCase(c));
                    upperCase = false;
                    continue;
                }
                sb.append(otherCharToLower ? Character.toLowerCase(c) : c);
            }
            return sb.toString();
        }
        if (otherCharToLower) {
            if (StringKit.isUpperCase(name2)) {
                return name2.toLowerCase();
            }
            return StringKit.lowerFirst(name2);
        }
        return name2;
    }

    public static boolean isUpperCase(CharSequence text) {
        if (null == text) {
            return false;
        }
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            if (!Character.isLowerCase(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isLowerCase(CharSequence text) {
        if (null == text) {
            return false;
        }
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            if (!Character.isUpperCase(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String swapCase(String text) {
        if (StringKit.isEmpty(text)) {
            return text;
        }
        char[] buffer = text.toCharArray();
        for (int i = 0; i < buffer.length; ++i) {
            char ch = buffer[i];
            if (Character.isUpperCase(ch) || Character.isTitleCase(ch)) {
                buffer[i] = Character.toLowerCase(ch);
                continue;
            }
            if (!Character.isLowerCase(ch)) continue;
            buffer[i] = Character.toUpperCase(ch);
        }
        return new String(buffer);
    }
}

