/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.xyz;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.RandomAccess;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import org.miaixz.bus.core.center.iterator.EnumerationIterator;
import org.miaixz.bus.core.center.list.AvgPartition;
import org.miaixz.bus.core.center.list.Partition;
import org.miaixz.bus.core.center.list.RandomAccessAvgPartition;
import org.miaixz.bus.core.center.list.RandomAccessPartition;
import org.miaixz.bus.core.compare.PinyinCompare;
import org.miaixz.bus.core.compare.PropertyCompare;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.Validator;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.CollKit;
import org.miaixz.bus.core.xyz.ObjectKit;

public class ListKit {
    @SafeVarargs
    public static <T> ArrayList<T> of(T ... values) {
        if (ArrayKit.isEmpty(values)) {
            return new ArrayList();
        }
        ArrayList arrayList = new ArrayList(values.length);
        Collections.addAll(arrayList, values);
        return arrayList;
    }

    @SafeVarargs
    public static <T> LinkedList<T> ofLinked(T ... values) {
        LinkedList list = new LinkedList();
        if (ArrayKit.isNotEmpty(values)) {
            Collections.addAll(list, values);
        }
        return list;
    }

    public static <T> List<T> of(boolean isLinked) {
        return isLinked ? ListKit.ofLinked(new Object[0]) : ListKit.of(new Object[0]);
    }

    public static <T> List<T> of(boolean isLinked, Iterable<T> iterable) {
        if (null == iterable) {
            return ListKit.of(isLinked);
        }
        if (iterable instanceof Collection) {
            Collection collection = (Collection)iterable;
            return isLinked ? new LinkedList(collection) : new ArrayList(collection);
        }
        return ListKit.of(isLinked, iterable.iterator());
    }

    public static <T> List<T> of(boolean isLinked, Enumeration<T> enumration) {
        return ListKit.of(isLinked, new EnumerationIterator<T>(enumration));
    }

    public static <T> List<T> of(boolean isLinked, Iterator<T> iter) {
        List<T> list = ListKit.of(isLinked);
        if (null != iter) {
            while (iter.hasNext()) {
                list.add(iter.next());
            }
        }
        return list;
    }

    public static <T> ArrayList<T> of(Iterable<T> iterable) {
        return (ArrayList)ListKit.of(false, iterable);
    }

    public static <T> ArrayList<T> of(Iterator<T> iterator) {
        return (ArrayList)ListKit.of(false, iterator);
    }

    public static <T> ArrayList<T> of(Enumeration<T> enumeration) {
        return (ArrayList)ListKit.of(false, enumeration);
    }

    @SafeVarargs
    public static <T> List<T> view(T ... ts) {
        return ListKit.view(ListKit.of(ts));
    }

    public static <T> List<T> view(List<T> ts) {
        if (ArrayKit.isEmpty(ts)) {
            return ListKit.empty();
        }
        return Collections.unmodifiableList(ts);
    }

    public static <T> List<T> empty() {
        return Collections.emptyList();
    }

    public static <T> List<T> zero() {
        return new ArrayList(0);
    }

    public static <T> CopyOnWriteArrayList<T> ofCopyOnWrite(Collection<T> collection) {
        return null == collection ? new CopyOnWriteArrayList() : new CopyOnWriteArrayList<T>(collection);
    }

    @SafeVarargs
    public static <T> CopyOnWriteArrayList<T> ofCopyOnWrite(T ... ts) {
        return null == ts ? new CopyOnWriteArrayList() : new CopyOnWriteArrayList<T>(ts);
    }

    public static <T> List<T> sort(List<T> list) {
        return ListKit.sort(list, null);
    }

    public static <T> List<T> sort(List<T> list, Comparator<? super T> c) {
        if (CollKit.isEmpty(list)) {
            return list;
        }
        if (null == c) {
            c = Comparator.nullsFirst(Comparator.naturalOrder());
        }
        list.sort(c);
        return list;
    }

    public static <T> List<T> sortByProperty(List<T> list, String property) {
        return ListKit.sort(list, new PropertyCompare(property));
    }

    public static List<String> sortByPinyin(List<String> list) {
        return ListKit.sort(list, new PinyinCompare());
    }

    public static <T> List<T> reverse(List<T> list) {
        if (CollKit.isEmpty(list)) {
            return list;
        }
        Collections.reverse(list);
        return list;
    }

    public static <T> List<T> reverseNew(List<T> list) {
        List<T> list2 = ObjectKit.clone(list);
        if (null == list2) {
            list2 = new ArrayList<T>(list);
        }
        try {
            return ListKit.reverse(list2);
        }
        catch (UnsupportedOperationException e) {
            return ListKit.reverse(ListKit.of(list));
        }
    }

    public static <T> List<T> setOrAppend(List<T> list, int index, T element) {
        if (index < list.size()) {
            list.set(index, element);
        } else {
            list.add(element);
        }
        return list;
    }

    public static <T> List<T> setOrPadding(List<T> list, int index, T element) {
        return ListKit.setOrPadding(list, index, element, null);
    }

    public static <T> List<T> setOrPadding(List<T> list, int index, T element, T paddingElement) {
        return ListKit.setOrPadding(list, index, element, paddingElement, (list.size() + 1) * 10);
    }

    public static <T> List<T> setOrPadding(List<T> list, int index, T element, T paddingElement, int indexLimit) {
        Assert.notNull(list, "List must be not null !", new Object[0]);
        int size = list.size();
        if (index < size) {
            list.set(index, element);
        } else {
            if (indexLimit > 0) {
                Validator.checkIndexLimit(index, indexLimit);
            }
            for (int i = size; i < index; ++i) {
                list.add(paddingElement);
            }
            list.add(element);
        }
        return list;
    }

    public static <T> List<T> sub(List<T> list, int begionInclude, int endExclude) {
        return ListKit.sub(list, begionInclude, endExclude, 1);
    }

    public static <T> List<T> sub(List<T> list, int begionInclude, int endExclude, int step) {
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return new ArrayList(0);
        }
        int size = list.size();
        if (begionInclude < 0) {
            begionInclude += size;
        }
        if (endExclude < 0) {
            endExclude += size;
        }
        if (begionInclude == size) {
            return new ArrayList(0);
        }
        if (begionInclude > endExclude) {
            int tmp = begionInclude;
            begionInclude = endExclude;
            endExclude = tmp;
        }
        if (endExclude > size) {
            if (begionInclude >= size) {
                return new ArrayList(0);
            }
            endExclude = size;
        }
        if (step < 1) {
            step = 1;
        }
        ArrayList<T> result = new ArrayList<T>();
        for (int i = begionInclude; i < endExclude; i += step) {
            result.add(list.get(i));
        }
        return result;
    }

    public static <T> int lastIndexOf(List<T> list, Predicate<? super T> matcher) {
        int size;
        if (null != list && (size = list.size()) > 0) {
            for (int i = size - 1; i >= 0; --i) {
                if (null != matcher && !matcher.test(list.get(i))) continue;
                return i;
            }
        }
        return -1;
    }

    public static <T> List<List<T>> partition(List<T> list, int size) {
        if (CollKit.isEmpty(list)) {
            return ListKit.empty();
        }
        return list instanceof RandomAccess ? new RandomAccessPartition<T>(list, size) : new Partition<T>(list, size);
    }

    public static <T> List<List<T>> avgPartition(List<T> list, int limit) {
        if (CollKit.isEmpty(list)) {
            return ListKit.empty();
        }
        return list instanceof RandomAccess ? new RandomAccessAvgPartition<T>(list, limit) : new AvgPartition<T>(list, limit);
    }

    public static <T> void swapTo(List<T> list, T element, Integer targetIndex) {
        int index;
        if (CollKit.isNotEmpty(list) && (index = list.indexOf(element)) >= 0) {
            Collections.swap(list, index, (int)targetIndex);
        }
    }

    public static <T> void swapElement(List<T> list, T element, T targetElement) {
        int targetIndex;
        if (CollKit.isNotEmpty(list) && (targetIndex = list.indexOf(targetElement)) >= 0) {
            ListKit.swapTo(list, element, targetIndex);
        }
    }

    public static <T> List<T> unmodifiable(List<? extends T> c) {
        if (null == c) {
            return null;
        }
        return Collections.unmodifiableList(c);
    }

    public static <T> List<T> addAllIfNotContains(List<T> list, List<T> otherList) {
        for (T t : otherList) {
            if (list.contains(t)) continue;
            list.add(t);
        }
        return list;
    }

    @SafeVarargs
    public static <T> List<T> splice(List<T> list, int start, int deleteCount, T ... items) {
        if (CollKit.isEmpty(list)) {
            return ListKit.zero();
        }
        int size = list.size();
        if (start < 0) {
            start += size;
        } else if (start >= size) {
            start = size;
            deleteCount = 0;
        }
        if (start + deleteCount > size) {
            deleteCount = size - start;
        }
        int newSize = size - deleteCount + items.length;
        List<T> resList = list;
        if (newSize > size) {
            resList = new ArrayList<T>(newSize);
            resList.addAll(list);
        }
        if (deleteCount > 0) {
            resList.subList(start, start + deleteCount).clear();
        }
        if (ArrayKit.isNotEmpty(items)) {
            resList.addAll(start, Arrays.asList(items));
        }
        return resList;
    }

    public static <T> List<T> page(int pageNo, int pageSize, List<T> list) {
        if (CollKit.isEmpty(list)) {
            return new ArrayList(0);
        }
        int resultSize = list.size();
        if (resultSize <= pageSize) {
            if (pageNo <= 1) {
                return ListKit.unmodifiable(list);
            }
            return new ArrayList(0);
        }
        if (pageNo < 1) {
            pageNo = 1;
        }
        if (pageSize < 1) {
            pageSize = 0;
        }
        int start = (pageNo - 1) * pageSize;
        int end = start + pageSize;
        int[] startEnd = new int[]{start, end};
        if (startEnd[1] > resultSize) {
            startEnd[1] = resultSize;
            if (startEnd[0] > startEnd[1]) {
                return new ArrayList(0);
            }
        }
        return ListKit.sub(list, startEnd[0], startEnd[1]);
    }

    public static <T> List<T> move(List<T> list, T element, int newPosition) {
        Assert.notNull(list);
        if (!list.contains(element)) {
            list.add(newPosition, element);
        } else {
            list.remove(element);
            list.add(newPosition, element);
        }
        return list;
    }
}

