/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.xyz;

import org.miaixz.bus.core.center.regex.Pattern;
import org.miaixz.bus.core.lang.Regex;
import org.miaixz.bus.core.lang.Validator;
import org.miaixz.bus.core.xyz.PatternKit;
import org.miaixz.bus.core.xyz.StringKit;

public class PhoneKit {
    public static boolean isMobile(CharSequence value) {
        return Validator.isMatchRegex(Regex.MOBILE_PATTERN, value);
    }

    public static boolean isMobileHk(CharSequence value) {
        return Validator.isMatchRegex("(?:0|852|\\+852)?\\d{8}", value);
    }

    public static boolean isMobileTw(CharSequence value) {
        return Validator.isMatchRegex(Pattern.MOBILE_TW_PATTERN, value);
    }

    public static boolean isMobileMo(CharSequence value) {
        return Validator.isMatchRegex("(?:0|853|\\+853)?(?:|-)6\\d{7}", value);
    }

    public static boolean isTel(CharSequence value) {
        return Validator.isMatchRegex(Pattern.TEL_PATTERN, value);
    }

    public static boolean isTel400800(CharSequence value) {
        return Validator.isMatchRegex("0\\d{2,3}[\\- ]?[1-9]\\d{6,7}|[48]00[\\- ]?[1-9]\\d{2}[\\- ]?\\d{4}", value);
    }

    public static boolean isPhone(CharSequence value) {
        return PhoneKit.isMobile(value) || PhoneKit.isTel400800(value) || PhoneKit.isMobileHk(value) || PhoneKit.isMobileTw(value) || PhoneKit.isMobileMo(value);
    }

    public static CharSequence hideBefore(CharSequence phone) {
        return StringKit.hide(phone, 0, 7);
    }

    public static CharSequence hideBetween(CharSequence phone) {
        return StringKit.hide(phone, 3, 7);
    }

    public static CharSequence hideAfter(CharSequence phone) {
        return StringKit.hide(phone, 7, 11);
    }

    public static CharSequence subBefore(CharSequence phone) {
        return StringKit.sub(phone, 0, 3);
    }

    public static CharSequence subBetween(CharSequence phone) {
        return StringKit.sub(phone, 3, 7);
    }

    public static CharSequence subAfter(CharSequence phone) {
        return StringKit.sub(phone, 7, 11);
    }

    public static CharSequence subTelBefore(CharSequence value) {
        return PatternKit.getGroup1(Pattern.TEL_PATTERN, value);
    }

    public static CharSequence subTelAfter(CharSequence value) {
        return PatternKit.get(Pattern.TEL_PATTERN, value, 2);
    }
}

