/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.annotation.resolve;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.function.IntConsumer;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.miaixz.bus.core.annotation.Alias;
import org.miaixz.bus.core.annotation.resolve.AnnotationMapping;
import org.miaixz.bus.core.annotation.resolve.AnnotationMappingProxy;
import org.miaixz.bus.core.center.map.multi.Graph;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.text.CharsBacker;
import org.miaixz.bus.core.xyz.AnnoKit;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.ClassKit;
import org.miaixz.bus.core.xyz.CollKit;
import org.miaixz.bus.core.xyz.MethodKit;

public class ResolvedAnnotationMapping
implements AnnotationMapping<Annotation> {
    protected static final int NOT_FOUND_INDEX = -1;
    private final Method[] attributes;
    private final AliasSet[] aliasSets;
    private final int[] resolvedAttributes;
    private final ResolvedAnnotationMapping[] resolvedAttributeSources;
    private final ResolvedAnnotationMapping source;
    private final Annotation annotation;
    private final boolean resolved;
    private volatile Annotation proxied;

    public ResolvedAnnotationMapping(ResolvedAnnotationMapping source, Annotation annotation, boolean resolveAttribute) {
        Objects.requireNonNull(annotation);
        Assert.isFalse(AnnotationMappingProxy.isProxied(annotation), "annotation has been proxied", new Object[0]);
        Assert.isFalse(annotation instanceof ResolvedAnnotationMapping, "annotation has been wrapped", new Object[0]);
        Assert.isFalse(Objects.nonNull(source) && Objects.equals(source.annotation, annotation), "source annotation can not same with target [{}]", annotation);
        this.annotation = annotation;
        this.attributes = AnnoKit.getAnnotationAttributes(annotation.annotationType());
        this.source = source;
        this.aliasSets = new AliasSet[this.attributes.length];
        this.resolvedAttributeSources = new ResolvedAnnotationMapping[this.attributes.length];
        this.resolvedAttributes = new int[this.attributes.length];
        Arrays.fill(this.resolvedAttributes, -1);
        this.resolved = resolveAttribute && this.resolveAttributes();
    }

    public static ResolvedAnnotationMapping create(Annotation annotation, boolean resolveAnnotationAttribute) {
        return ResolvedAnnotationMapping.create(null, annotation, resolveAnnotationAttribute);
    }

    public static ResolvedAnnotationMapping create(ResolvedAnnotationMapping source, Annotation annotation, boolean resolveAnnotationAttribute) {
        return new ResolvedAnnotationMapping(source, annotation, resolveAnnotationAttribute);
    }

    private boolean resolveAttributes() {
        this.resolveAliasAttributes();
        this.resolveOverwriteAttributes();
        return IntStream.of(this.resolvedAttributes).anyMatch(idx -> -1 != idx);
    }

    @Override
    public boolean isRoot() {
        return Objects.isNull(this.source);
    }

    public ResolvedAnnotationMapping getRoot() {
        ResolvedAnnotationMapping mapping = this;
        while (Objects.nonNull(mapping.source)) {
            mapping = mapping.source;
        }
        return mapping;
    }

    @Override
    public Method[] getAttributes() {
        return this.attributes;
    }

    @Override
    public Annotation getAnnotation() {
        return this.annotation;
    }

    @Override
    public boolean isResolved() {
        return this.resolved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Annotation getResolvedAnnotation() {
        if (!this.isResolved()) {
            return this.annotation;
        }
        if (Objects.isNull(this.proxied)) {
            ResolvedAnnotationMapping resolvedAnnotationMapping = this;
            synchronized (resolvedAnnotationMapping) {
                if (Objects.isNull(this.proxied)) {
                    this.proxied = AnnotationMappingProxy.create(this.annotationType(), this);
                }
            }
        }
        return this.proxied;
    }

    public boolean hasAttribute(String attributeName, Class<?> attributeType) {
        return this.getAttributeIndex(attributeName, attributeType) != -1;
    }

    public boolean hasAttribute(int index) {
        return index != -1 && Objects.nonNull(ArrayKit.get(this.attributes, index));
    }

    public int getAttributeIndex(String attributeName, Class<?> attributeType) {
        for (int i = 0; i < this.attributes.length; ++i) {
            Method attribute = this.attributes[i];
            if (!CharsBacker.equals(attribute.getName(), attributeName) || !ClassKit.isAssignable(attributeType, attribute.getReturnType())) continue;
            return i;
        }
        return -1;
    }

    public Method getAttribute(int index) {
        return (Method)ArrayKit.get(this.attributes, index);
    }

    @Override
    public <R> R getAttributeValue(String attributeName, Class<R> attributeType) {
        return this.getAttributeValue(this.getAttributeIndex(attributeName, attributeType));
    }

    public <R> R getAttributeValue(int index) {
        return this.hasAttribute(index) ? (R)MethodKit.invoke((Object)this.annotation, this.attributes[index], new Object[0]) : null;
    }

    @Override
    public <R> R getResolvedAttributeValue(String attributeName, Class<R> attributeType) {
        return this.getResolvedAttributeValue(this.getAttributeIndex(attributeName, attributeType));
    }

    public <R> R getResolvedAttributeValue(int index) {
        if (!this.hasAttribute(index)) {
            return null;
        }
        int resolvedIndex = this.resolvedAttributes[index];
        if (resolvedIndex == -1) {
            return this.getAttributeValue(index);
        }
        ResolvedAnnotationMapping attributeSource = this.resolvedAttributeSources[index];
        if (Objects.isNull(attributeSource)) {
            return this.getAttributeValue(resolvedIndex);
        }
        return attributeSource.getResolvedAttributeValue(resolvedIndex);
    }

    private void resolveOverwriteAttributes() {
        if (Objects.isNull(this.source)) {
            return;
        }
        LinkedList<ResolvedAnnotationMapping> sources = new LinkedList<ResolvedAnnotationMapping>();
        HashSet<Class<Annotation>> accessed = new HashSet<Class<Annotation>>();
        accessed.add(this.annotationType());
        ResolvedAnnotationMapping sourceMapping = this.source;
        while (Objects.nonNull(sourceMapping)) {
            Assert.isFalse(accessed.contains(sourceMapping.annotationType()), "circular dependency between [{}] and [{}]", this.annotationType(), sourceMapping.annotationType());
            sources.addFirst(sourceMapping);
            accessed.add(this.source.annotationType());
            sourceMapping = sourceMapping.source;
        }
        for (ResolvedAnnotationMapping mapping : sources) {
            this.updateResolvedAttributesByOverwrite(mapping);
        }
    }

    private void updateResolvedAttributesByOverwrite(ResolvedAnnotationMapping overwriteMapping) {
        for (int overwriteIndex = 0; overwriteIndex < overwriteMapping.getAttributes().length; ++overwriteIndex) {
            Method overwrite = overwriteMapping.getAttribute(overwriteIndex);
            for (int targetIndex = 0; targetIndex < this.attributes.length; ++targetIndex) {
                Method attribute = this.attributes[targetIndex];
                if (!CharsBacker.equals(attribute.getName(), overwrite.getName()) || !ClassKit.isAssignable(attribute.getReturnType(), overwrite.getReturnType())) continue;
                this.overwriteAttribute(overwriteMapping, overwriteIndex, targetIndex, true);
            }
        }
    }

    private void overwriteAttribute(ResolvedAnnotationMapping overwriteMapping, int overwriteIndex, int targetIndex, boolean overwriteAliases) {
        if (this.isOverwrittenAttribute(targetIndex)) {
            return;
        }
        this.resolvedAttributes[targetIndex] = overwriteIndex;
        this.resolvedAttributeSources[targetIndex] = overwriteMapping;
        if (overwriteAliases && Objects.nonNull(this.aliasSets[targetIndex])) {
            this.aliasSets[targetIndex].forEach(aliasIndex -> this.overwriteAttribute(overwriteMapping, overwriteIndex, aliasIndex, false));
        }
    }

    private boolean isOverwrittenAttribute(int index) {
        return -1 != this.resolvedAttributes[index] && Objects.nonNull(this.resolvedAttributeSources[index]);
    }

    private void resolveAliasAttributes() {
        HashMap<Method, Integer> attributeIndexes = new HashMap<Method, Integer>(this.attributes.length);
        Graph<Method> methodGraph = new Graph<Method>();
        for (int i = 0; i < this.attributes.length; ++i) {
            Method attribute = this.attributes[i];
            attributeIndexes.put(attribute, i);
            Alias attributeAnnotation = attribute.getAnnotation(Alias.class);
            if (Objects.isNull(attributeAnnotation)) continue;
            Method aliasAttribute = this.getAliasAttribute(attribute, attributeAnnotation);
            Objects.requireNonNull(aliasAttribute);
            methodGraph.putEdge(aliasAttribute, attribute);
        }
        HashSet<Method> accessed = new HashSet<Method>(this.attributes.length);
        LinkedHashSet<Method> group = new LinkedHashSet<Method>();
        LinkedList<Method> deque = new LinkedList<Method>();
        for (Method target : methodGraph.keySet()) {
            group.clear();
            deque.addLast(target);
            while (!deque.isEmpty()) {
                Method curr = (Method)deque.removeFirst();
                if (accessed.contains(curr)) continue;
                accessed.add(curr);
                group.add(curr);
                Collection<Method> aliases = methodGraph.getAdjacentPoints(curr);
                if (!CollKit.isNotEmpty(aliases)) continue;
                deque.addAll(aliases);
            }
            int[] groupIndexes = group.stream().mapToInt(attributeIndexes::get).toArray();
            this.updateAliasSetsForAliasGroup(groupIndexes);
        }
        Stream.of(this.aliasSets).filter(Objects::nonNull).forEach(set -> {
            int effectiveAttributeIndex = set.determineEffectiveAttribute();
            set.forEach(index -> {
                this.resolvedAttributes[index] = effectiveAttributeIndex;
            });
        });
    }

    private Method getAliasAttribute(Method attribute, Alias attributeAnnotation) {
        int aliasAttributeIndex = this.getAttributeIndex(attributeAnnotation.value(), attribute.getReturnType());
        Assert.isTrue(this.hasAttribute(aliasAttributeIndex), "can not find alias attribute [{}] in [{}]", attributeAnnotation.value(), this.annotation.annotationType());
        Method aliasAttribute = this.getAttribute(aliasAttributeIndex);
        Assert.notEquals(aliasAttribute, attribute, "attribute [{}] can not alias for itself", attribute);
        Assert.isAssignable(attribute.getReturnType(), aliasAttribute.getReturnType(), "aliased attributes [{}] and [{}] must have same return type", attribute, aliasAttribute);
        return aliasAttribute;
    }

    private void updateAliasSetsForAliasGroup(int[] groupIndexes) {
        AliasSet set = new AliasSet(groupIndexes);
        for (int index : groupIndexes) {
            this.aliasSets[index] = set;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResolvedAnnotationMapping that = (ResolvedAnnotationMapping)o;
        return this.resolved == that.resolved && this.annotation.equals(that.annotation);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.annotation, this.resolved);
    }

    private class AliasSet {
        final int[] indexes;

        AliasSet(int[] indexes) {
            this.indexes = indexes;
        }

        private int determineEffectiveAttribute() {
            int resolvedIndex = -1;
            boolean hasNotDef = false;
            Object lastValue = null;
            for (int index : this.indexes) {
                Method attribute = ResolvedAnnotationMapping.this.attributes[index];
                Object def = attribute.getDefaultValue();
                Object undef = MethodKit.invoke((Object)ResolvedAnnotationMapping.this.annotation, attribute, new Object[0]);
                boolean isDefault = Objects.equals(def, undef);
                if (resolvedIndex == -1) {
                    resolvedIndex = index;
                    lastValue = isDefault ? def : undef;
                    hasNotDef = !isDefault;
                    continue;
                }
                if (hasNotDef) {
                    if (isDefault) continue;
                    Assert.isTrue(Objects.equals(lastValue, undef), "aliased attribute [{}] and [{}] must have same not default value, but is different: [{}] <==> [{}]", ResolvedAnnotationMapping.this.attributes[resolvedIndex], attribute, lastValue, undef);
                    continue;
                }
                if (!isDefault) {
                    hasNotDef = true;
                    lastValue = undef;
                    resolvedIndex = index;
                    continue;
                }
                Assert.isTrue(Objects.equals(lastValue, def), "aliased attribute [{}] and [{}] must have same default value, but is different: [{}] <==> [{}]", ResolvedAnnotationMapping.this.attributes[resolvedIndex], attribute, lastValue, def);
            }
            Assert.isFalse(resolvedIndex == -1, "can not resolve aliased attributes from [{}]", ResolvedAnnotationMapping.this.annotation);
            return resolvedIndex;
        }

        void forEach(IntConsumer consumer) {
            for (int index : this.indexes) {
                consumer.accept(index);
            }
        }
    }
}

