/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.basics.entity;

import jakarta.persistence.Id;
import java.io.Serializable;
import org.miaixz.bus.core.xyz.FieldKit;

public class Entity
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    protected String id;

    public <T> boolean isPKNotNull(T entity, String field) {
        if (!FieldKit.hasField(entity.getClass(), field)) {
            return false;
        }
        Object value = FieldKit.getFieldValue(entity, field);
        return null != value && !"".equals(value);
    }

    public <T> Object getValue(T entity, String field) {
        if (FieldKit.hasField(entity.getClass(), field)) {
            Object value = FieldKit.getFieldValue(entity, field);
            return null != value ? value.toString() : null;
        }
        return null;
    }

    public <T> void setValue(T entity, String[] fields, Object[] value) {
        for (int i = 0; i < fields.length; ++i) {
            String field = fields[i];
            if (!FieldKit.hasField(entity.getClass(), field)) continue;
            FieldKit.setFieldValue(entity, field, value[i]);
        }
    }

    protected Entity(EntityBuilder<?, ?> b) {
        this.id = b.id;
    }

    public static EntityBuilder<?, ?> builder() {
        return new EntityBuilderImpl();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Entity() {
    }

    public Entity(String id) {
        this.id = id;
    }

    public static abstract class EntityBuilder<C extends Entity, B extends EntityBuilder<C, B>> {
        private String id;

        public B id(String id) {
            this.id = id;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "Entity.EntityBuilder(id=" + this.id + ")";
        }
    }

    private static final class EntityBuilderImpl
    extends EntityBuilder<Entity, EntityBuilderImpl> {
        private EntityBuilderImpl() {
        }

        @Override
        protected EntityBuilderImpl self() {
            return this;
        }

        @Override
        public Entity build() {
            return new Entity(this);
        }
    }
}

