/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.beans.path;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.miaixz.bus.core.beans.BeanDesc;
import org.miaixz.bus.core.beans.PropDesc;
import org.miaixz.bus.core.center.map.CaseInsensitiveMap;
import org.miaixz.bus.core.lang.Assert;

public abstract class AbstractBeanDesc
implements BeanDesc {
    private static final long serialVersionUID = 1L;
    protected final Class<?> beanClass;
    protected final Map<String, PropDesc> propMap = new LinkedHashMap<String, PropDesc>();

    public AbstractBeanDesc(Class<?> beanClass) {
        this.beanClass = Assert.notNull(beanClass);
    }

    public String getName() {
        return this.beanClass.getName();
    }

    public String getSimpleName() {
        return this.beanClass.getSimpleName();
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    @Override
    public Map<String, PropDesc> getPropMap(boolean ignoreCase) {
        return ignoreCase ? new CaseInsensitiveMap<String, PropDesc>(1.0f, this.propMap) : this.propMap;
    }

    @Override
    public Collection<PropDesc> getProps() {
        return this.propMap.values();
    }

    @Override
    public PropDesc getProp(String fieldName) {
        return this.propMap.get(fieldName);
    }

    public Field getField(String fieldName) {
        PropDesc desc = this.propMap.get(fieldName);
        return null == desc ? null : desc.getField();
    }

    public Method getGetter(String fieldName) {
        PropDesc desc = this.propMap.get(fieldName);
        return null == desc ? null : desc.getGetter();
    }

    public Method getSetter(String fieldName) {
        PropDesc desc = this.propMap.get(fieldName);
        return null == desc ? null : desc.getSetter();
    }
}

