/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.cache;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.miaixz.bus.core.center.function.SupplierX;
import org.miaixz.bus.core.center.iterator.TransIterator;
import org.miaixz.bus.core.center.map.concurrent.SafeConcurrentHashMap;
import org.miaixz.bus.core.center.map.reference.WeakConcurrentMap;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.mutable.Mutable;
import org.miaixz.bus.core.lang.mutable.MutableObject;

public class SimpleCache<K, V>
implements Iterable<Map.Entry<K, V>>,
Serializable {
    private static final long serialVersionUID = -1L;
    protected final Map<K, Lock> keyLockMap = new SafeConcurrentHashMap<K, Lock>();
    private final Map<Mutable<K>, V> rawMap;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public SimpleCache() {
        this(new WeakConcurrentMap());
    }

    public SimpleCache(Map<Mutable<K>, V> initMap) {
        this.rawMap = initMap;
    }

    public boolean containsKey(K key) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.rawMap.containsKey(MutableObject.of(key));
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public V get(K key) {
        this.lock.readLock().lock();
        try {
            V v = this.rawMap.get(MutableObject.of(key));
            return v;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public V get(K key, SupplierX<V> supplier) {
        return this.get(key, null, supplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key, Predicate<V> validPredicate, SupplierX<V> supplier) {
        V v = this.get(key);
        if (null != validPredicate && null != v && !validPredicate.test(v)) {
            v = null;
        }
        if (null == v && null != supplier) {
            Lock keyLock = this.keyLockMap.computeIfAbsent(key, k -> new ReentrantLock());
            keyLock.lock();
            try {
                v = this.get(key);
                if (null == v || null != validPredicate && !validPredicate.test(v)) {
                    v = supplier.get();
                    this.put(key, v);
                }
            }
            finally {
                keyLock.unlock();
                this.keyLockMap.remove(key);
            }
        }
        return v;
    }

    public V put(K key, V value) {
        Assert.notNull(value, "'value' must not be null", new Object[0]);
        this.lock.writeLock().lock();
        try {
            this.rawMap.put(MutableObject.of(key), value);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return value;
    }

    public V remove(K key) {
        this.lock.writeLock().lock();
        try {
            V v = this.rawMap.remove(MutableObject.of(key));
            return v;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.rawMap.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return new TransIterator<Map.Entry, Map.Entry>(this.rawMap.entrySet().iterator(), entry -> new Map.Entry<K, V>(this, (Map.Entry)entry){
            final /* synthetic */ Map.Entry val$entry;
            {
                this.val$entry = entry;
            }

            @Override
            public K getKey() {
                return ((Mutable)this.val$entry.getKey()).get();
            }

            @Override
            public V getValue() {
                return this.val$entry.getValue();
            }

            @Override
            public V setValue(V value) {
                return this.val$entry.setValue(value);
            }
        });
    }

    public List<K> keys() {
        return this.rawMap.keySet().stream().map(Mutable::get).collect(Collectors.toList());
    }
}

