/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.date.builder;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.miaixz.bus.core.lang.exception.DateException;
import org.miaixz.bus.core.xyz.ZoneKit;

public final class DateBuilder {
    private static final ZoneOffset DEFAULT_OFFSET = OffsetDateTime.now().getOffset();
    private int year;
    private int month;
    private int week;
    private int day;
    private int hour;
    private int minute;
    private int second;
    private int ns;
    private long unixsecond;
    private boolean zoneOffsetSetted;
    private int zoneOffset;
    private TimeZone zone;
    private boolean am;
    private boolean pm;

    public static DateBuilder of() {
        return new DateBuilder();
    }

    public int getYear() {
        return this.year;
    }

    public DateBuilder setYear(int year) {
        this.year = year;
        return this;
    }

    public int getMonth() {
        return this.month;
    }

    public DateBuilder setMonth(int month) {
        this.month = month;
        return this;
    }

    public int getWeek() {
        return this.week;
    }

    public DateBuilder setWeek(int week) {
        this.week = week;
        return this;
    }

    public int getDay() {
        return this.day;
    }

    public DateBuilder setDay(int day) {
        this.day = day;
        return this;
    }

    public int getHour() {
        return this.hour;
    }

    public DateBuilder setHour(int hour) {
        this.hour = hour;
        return this;
    }

    public int getMinute() {
        return this.minute;
    }

    public DateBuilder setMinute(int minute) {
        this.minute = minute;
        return this;
    }

    public int getSecond() {
        return this.second;
    }

    public DateBuilder setSecond(int second) {
        this.second = second;
        return this;
    }

    public int getNs() {
        return this.ns;
    }

    public DateBuilder setNs(int ns) {
        this.ns = ns;
        return this;
    }

    public long getUnixsecond() {
        return this.unixsecond;
    }

    public DateBuilder setUnixsecond(long unixsecond) {
        this.unixsecond = unixsecond;
        return this;
    }

    public boolean isZoneOffsetSetted() {
        return this.zoneOffsetSetted;
    }

    public DateBuilder setZoneOffsetSetted(boolean zoneOffsetSetted) {
        this.zoneOffsetSetted = zoneOffsetSetted;
        return this;
    }

    public int getZoneOffset() {
        return this.zoneOffset;
    }

    public DateBuilder setZoneOffset(int zoneOffset) {
        this.zoneOffset = zoneOffset;
        return this;
    }

    public TimeZone getZone() {
        return this.zone;
    }

    public DateBuilder setZone(TimeZone zone) {
        this.zone = zone;
        return this;
    }

    public boolean isAm() {
        return this.am;
    }

    public DateBuilder setAm(boolean am) {
        this.am = am;
        return this;
    }

    public boolean isPm() {
        return this.pm;
    }

    public DateBuilder setPm(boolean pm) {
        this.pm = pm;
        return this;
    }

    public DateBuilder reset() {
        this.week = 1;
        this.year = 0;
        this.month = 1;
        this.day = 1;
        this.hour = 0;
        this.minute = 0;
        this.second = 0;
        this.ns = 0;
        this.unixsecond = 0L;
        this.am = false;
        this.pm = false;
        this.zoneOffsetSetted = false;
        this.zoneOffset = 0;
        this.zone = null;
        return this;
    }

    public Date toDate() {
        if (!this.zoneOffsetSetted) {
            return this.toCalendar().getTime();
        }
        return Date.from(this.toOffsetDateTime().toInstant());
    }

    public Calendar toCalendar() {
        this.prepare();
        Calendar calendar = Calendar.getInstance();
        if (this.unixsecond != 0L) {
            calendar.setTimeInMillis(this.unixsecond * 1000L + (long)(this.ns / 1000000));
            return calendar;
        }
        if (this.zone != null) {
            calendar.setTimeZone(this.zone);
        } else if (this.zoneOffsetSetted) {
            String[] ids = TimeZone.getAvailableIDs(this.zoneOffset * 60000);
            if (ids.length == 0) {
                throw new DateException("Can't build Calendar, because the zoneOffset[{}] can't be converted to an valid TimeZone.", this.zoneOffset);
            }
            calendar.setTimeZone(TimeZone.getTimeZone(ids[0]));
        }
        calendar.set(1, this.year);
        calendar.set(2, this.month - 1);
        calendar.set(5, this.day);
        calendar.set(11, this.hour);
        calendar.set(12, this.minute);
        calendar.set(13, this.second);
        calendar.set(14, this.ns / 1000000);
        return calendar;
    }

    public LocalDateTime toLocalDateTime() {
        this.prepare();
        if (this.unixsecond > 0L) {
            return LocalDateTime.ofEpochSecond(this.unixsecond, this.ns, DEFAULT_OFFSET);
        }
        LocalDateTime dateTime = LocalDateTime.of(this.year, this.month, this.day, this.hour, this.minute, this.second, this.ns);
        int zoneSecond = 0;
        if (this.zone != null) {
            zoneSecond = (TimeZone.getDefault().getRawOffset() - this.zone.getRawOffset()) / 1000;
        }
        if (this.zoneOffsetSetted) {
            zoneSecond = TimeZone.getDefault().getRawOffset() / 1000 - this.zoneOffset * 60;
        }
        return zoneSecond == 0 ? dateTime : dateTime.plusSeconds(zoneSecond);
    }

    public OffsetDateTime toOffsetDateTime() {
        this.prepare();
        if (this.unixsecond > 0L) {
            return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.unixsecond, this.ns), ZoneKit.ZONE_ID_UTC);
        }
        LocalDateTime dateTime = LocalDateTime.of(this.year, this.month, this.day, this.hour, this.minute, this.second, this.ns);
        if (this.zoneOffsetSetted) {
            ZoneOffset offset = ZoneOffset.ofHoursMinutes(this.zoneOffset / 60, this.zoneOffset % 60);
            return dateTime.atOffset(offset);
        }
        if (this.zone != null) {
            return dateTime.atZone(this.zone.toZoneId()).toOffsetDateTime();
        }
        return dateTime.atZone(ZoneOffset.ofHoursMinutes(0, 0)).toOffsetDateTime();
    }

    private void prepare() {
        if (this.am && this.hour == 12) {
            this.hour = 0;
        }
        if (this.pm && this.hour != 12) {
            this.hour += 12;
        }
    }
}

