/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.date.culture.en;

import java.time.format.TextStyle;
import java.util.Locale;
import org.miaixz.bus.core.lang.Assert;

public enum Month {
    JANUARY(0),
    FEBRUARY(1),
    MARCH(2),
    APRIL(3),
    MAY(4),
    JUNE(5),
    JULY(6),
    AUGUST(7),
    SEPTEMBER(8),
    OCTOBER(9),
    NOVEMBER(10),
    DECEMBER(11),
    UNDECIMBER(12);

    private static final Month[] ENUMS;
    private final int value;

    private Month(int value) {
        this.value = value;
    }

    public static Month of(int calendarMonthIntValue) {
        if (calendarMonthIntValue >= ENUMS.length || calendarMonthIntValue < 0) {
            return null;
        }
        return ENUMS[calendarMonthIntValue];
    }

    public static Month of(String name) throws IllegalArgumentException {
        if (null != name && name.length() > 2) {
            switch (Character.toLowerCase(name.charAt(0))) {
                case 'a': {
                    switch (Character.toLowerCase(name.charAt(1))) {
                        case 'p': {
                            return APRIL;
                        }
                        case 'u': {
                            return AUGUST;
                        }
                    }
                    break;
                }
                case 'j': {
                    if (Character.toLowerCase(name.charAt(1)) == 'a') {
                        return JANUARY;
                    }
                    switch (Character.toLowerCase(name.charAt(2))) {
                        case 'n': {
                            return JUNE;
                        }
                        case 'l': {
                            return JULY;
                        }
                    }
                    break;
                }
                case 'f': {
                    return FEBRUARY;
                }
                case 'm': {
                    switch (Character.toLowerCase(name.charAt(2))) {
                        case 'r': {
                            return MARCH;
                        }
                        case 'y': {
                            return MAY;
                        }
                    }
                    break;
                }
                case 's': {
                    return SEPTEMBER;
                }
                case 'o': {
                    return OCTOBER;
                }
                case 'n': {
                    return NOVEMBER;
                }
                case 'd': {
                    return DECEMBER;
                }
            }
        }
        throw new IllegalArgumentException("Invalid Month name: " + name);
    }

    public static Month of(java.time.Month month) {
        return Month.of(month.ordinal());
    }

    public static int getLastDay(int month, boolean isLeapYear) {
        Month of = Month.of(month);
        Assert.notNull(of, "Invalid Month base 0: " + month, new Object[0]);
        return of.getLastDay(isLeapYear);
    }

    public int getValue() {
        return this.value;
    }

    public int getIsoValue() {
        Assert.isFalse(this == UNDECIMBER, "Unsupported Undecimber field", new Object[0]);
        return this.getValue() + 1;
    }

    public int getLastDay(boolean isLeapYear) {
        switch (this.ordinal()) {
            case 1: {
                return isLeapYear ? 29 : 28;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                return 30;
            }
        }
        return 31;
    }

    public java.time.Month toJdkMonth() {
        return java.time.Month.of(this.getIsoValue());
    }

    public String getDisplayName(TextStyle style) {
        return this.getDisplayName(style, Locale.getDefault());
    }

    public String getDisplayName(TextStyle style, Locale locale) {
        return this.toJdkMonth().getDisplayName(style, locale);
    }

    static {
        ENUMS = Month.values();
    }
}

