/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.date.culture.lunar;

import org.miaixz.bus.core.center.date.culture.Loops;
import org.miaixz.bus.core.center.date.culture.cn.birth.EightChar;
import org.miaixz.bus.core.center.date.culture.cn.sixty.EarthBranch;
import org.miaixz.bus.core.center.date.culture.cn.sixty.HeavenStem;
import org.miaixz.bus.core.center.date.culture.cn.sixty.SixtyCycle;
import org.miaixz.bus.core.center.date.culture.cn.star.nine.NineStar;
import org.miaixz.bus.core.center.date.culture.lunar.LunarDay;
import org.miaixz.bus.core.center.date.culture.lunar.LunarMonth;
import org.miaixz.bus.core.center.date.culture.lunar.LunarYear;
import org.miaixz.bus.core.center.date.culture.solar.SolarDay;
import org.miaixz.bus.core.center.date.culture.solar.SolarMonth;
import org.miaixz.bus.core.center.date.culture.solar.SolarTerms;
import org.miaixz.bus.core.center.date.culture.solar.SolarTime;

public class LunarHour
extends Loops {
    protected LunarDay day;
    protected int hour;
    protected int minute;
    protected int second;

    public LunarHour(int year, int month, int day, int hour, int minute, int second) {
        if (hour < 0 || hour > 23) {
            throw new IllegalArgumentException(String.format("illegal hour: %d", hour));
        }
        if (minute < 0 || minute > 59) {
            throw new IllegalArgumentException(String.format("illegal minute: %d", minute));
        }
        if (second < 0 || second > 59) {
            throw new IllegalArgumentException(String.format("illegal second: %d", second));
        }
        this.day = LunarDay.fromYmd(year, month, day);
        this.hour = hour;
        this.minute = minute;
        this.second = second;
    }

    public static LunarHour fromYmdHms(int year, int month, int day, int hour, int minute, int second) {
        return new LunarHour(year, month, day, hour, minute, second);
    }

    public LunarDay getDay() {
        return this.day;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    @Override
    public String getName() {
        return EarthBranch.fromIndex(this.getIndexInDay()).getName() + "\u65f6";
    }

    @Override
    public String toString() {
        return String.valueOf(this.day) + this.getSixtyCycle().getName() + "\u65f6";
    }

    public int getIndexInDay() {
        return (this.hour + 1) / 2;
    }

    @Override
    public LunarHour next(int n) {
        int h = this.hour + n * 2;
        int diff = h < 0 ? -1 : 1;
        int hour = Math.abs(h);
        int days = hour / 24 * diff;
        if ((hour = hour % 24 * diff) < 0) {
            hour += 24;
            --days;
        }
        LunarDay d = this.day.next(days);
        LunarMonth m = d.getMonth();
        return LunarHour.fromYmdHms(m.getYear().getYear(), m.getMonthWithLeap(), d.getDay(), hour, this.minute, this.second);
    }

    public boolean isBefore(LunarHour target) {
        if (!this.day.equals(target.getDay())) {
            return this.day.isBefore(target.getDay());
        }
        if (this.hour != target.getHour()) {
            return this.hour < target.getHour();
        }
        return this.minute != target.getMinute() ? this.minute < target.getMinute() : this.second < target.getSecond();
    }

    public boolean isAfter(LunarHour target) {
        if (!this.day.equals(target.getDay())) {
            return this.day.isAfter(target.getDay());
        }
        if (this.hour != target.getHour()) {
            return this.hour > target.getHour();
        }
        return this.minute != target.getMinute() ? this.minute > target.getMinute() : this.second > target.getSecond();
    }

    public SixtyCycle getYearSixtyCycle() {
        SolarTime solarTime = this.getSolarTime();
        int solarYear = this.day.getSolarDay().getMonth().getYear().getYear();
        SolarTime springSolarTime = SolarTerms.fromIndex(solarYear, 3).getJulianDay().getSolarTime();
        LunarYear lunarYear = this.day.getMonth().getYear();
        int year = lunarYear.getYear();
        SixtyCycle sixtyCycle = lunarYear.getSixtyCycle();
        if (year == solarYear) {
            if (solarTime.isBefore(springSolarTime)) {
                sixtyCycle = sixtyCycle.next(-1);
            }
        } else if (year < solarYear && !solarTime.isBefore(springSolarTime)) {
            sixtyCycle = sixtyCycle.next(1);
        }
        return sixtyCycle;
    }

    public SixtyCycle getMonthSixtyCycle() {
        SolarTime solarTime = this.getSolarTime();
        int year = solarTime.getDay().getMonth().getYear().getYear();
        SolarTerms term = solarTime.getTerm();
        int index = term.getIndex() - 3;
        if (index < 0 && term.getJulianDay().getSolarTime().isAfter(SolarTerms.fromIndex(year, 3).getJulianDay().getSolarTime())) {
            index += 24;
        }
        return LunarMonth.fromYm(year, 1).getSixtyCycle().next((int)Math.floor((double)index * 1.0 / 2.0));
    }

    public SixtyCycle getDaySixtyCycle() {
        SixtyCycle d = this.day.getSixtyCycle();
        return this.hour < 23 ? d : d.next(1);
    }

    public SixtyCycle getSixtyCycle() {
        int earthBranchIndex = this.getIndexInDay() % 12;
        int heavenStemIndex = this.getDaySixtyCycle().getHeavenStem().getIndex() % 5 * 2 + earthBranchIndex;
        return SixtyCycle.fromName(HeavenStem.fromIndex(heavenStemIndex).getName() + EarthBranch.fromIndex(earthBranchIndex).getName());
    }

    public NineStar getNineStar() {
        SolarDay solar = this.day.getSolarDay();
        SolarTerms dongZhi = SolarTerms.fromIndex(solar.getMonth().getYear().getYear(), 0);
        SolarTerms xiaZhi = dongZhi.next(12);
        boolean asc = !solar.isBefore(dongZhi.getJulianDay().getSolarDay()) && solar.isBefore(xiaZhi.getJulianDay().getSolarDay());
        int start = (new int[]{8, 5, 2})[this.day.getSixtyCycle().getEarthBranch().getIndex() % 3];
        if (asc) {
            start = 8 - start;
        }
        int earthBranchIndex = this.getIndexInDay() % 12;
        return NineStar.fromIndex(start + (asc ? earthBranchIndex : -earthBranchIndex));
    }

    public SolarTime getSolarTime() {
        SolarDay d = this.day.getSolarDay();
        SolarMonth m = d.getMonth();
        return SolarTime.fromYmdHms(m.getYear().getYear(), m.getMonth(), d.getDay(), this.hour, this.minute, this.second);
    }

    public EightChar getEightChar() {
        return new EightChar(this.getYearSixtyCycle(), this.getMonthSixtyCycle(), this.getDaySixtyCycle(), this.getSixtyCycle());
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof LunarHour)) {
            return false;
        }
        LunarHour target = (LunarHour)o;
        return this.day.equals(target.getDay()) && this.hour == target.getHour() && this.minute == target.getMinute() && this.second == target.getSecond();
    }
}

