/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.date.culture.solar;

import org.miaixz.bus.core.center.date.culture.Holiday;
import org.miaixz.bus.core.center.date.culture.Loops;
import org.miaixz.bus.core.center.date.culture.cn.JulianDay;
import org.miaixz.bus.core.center.date.culture.cn.Week;
import org.miaixz.bus.core.center.date.culture.cn.climate.Climate;
import org.miaixz.bus.core.center.date.culture.cn.climate.ClimateDay;
import org.miaixz.bus.core.center.date.culture.cn.dog.Dog;
import org.miaixz.bus.core.center.date.culture.cn.dog.DogDay;
import org.miaixz.bus.core.center.date.culture.cn.nine.Nine;
import org.miaixz.bus.core.center.date.culture.cn.nine.NineDay;
import org.miaixz.bus.core.center.date.culture.cn.plumrain.PlumRain;
import org.miaixz.bus.core.center.date.culture.cn.plumrain.PlumRainDay;
import org.miaixz.bus.core.center.date.culture.en.Constellation;
import org.miaixz.bus.core.center.date.culture.lunar.LunarDay;
import org.miaixz.bus.core.center.date.culture.lunar.LunarMonth;
import org.miaixz.bus.core.center.date.culture.solar.SolarFestival;
import org.miaixz.bus.core.center.date.culture.solar.SolarMonth;
import org.miaixz.bus.core.center.date.culture.solar.SolarTermDay;
import org.miaixz.bus.core.center.date.culture.solar.SolarTerms;
import org.miaixz.bus.core.center.date.culture.solar.SolarWeek;

public class SolarDay
extends Loops {
    public static final String[] NAMES = new String[]{"1\u65e5", "2\u65e5", "3\u65e5", "4\u65e5", "5\u65e5", "6\u65e5", "7\u65e5", "8\u65e5", "9\u65e5", "10\u65e5", "11\u65e5", "12\u65e5", "13\u65e5", "14\u65e5", "15\u65e5", "16\u65e5", "17\u65e5", "18\u65e5", "19\u65e5", "20\u65e5", "21\u65e5", "22\u65e5", "23\u65e5", "24\u65e5", "25\u65e5", "26\u65e5", "27\u65e5", "28\u65e5", "29\u65e5", "30\u65e5", "31\u65e5"};
    protected SolarMonth month;
    protected int day;

    public SolarDay(int year, int month, int day) {
        if (day < 1) {
            throw new IllegalArgumentException(String.format("illegal solar day: %d-%d-%d", year, month, day));
        }
        SolarMonth m = SolarMonth.fromYm(year, month);
        if (1582 == year && 10 == month ? day > 4 && day < 15 || day > 31 : day > m.getDayCount()) {
            throw new IllegalArgumentException(String.format("illegal solar day: %d-%d-%d", year, month, day));
        }
        this.month = m;
        this.day = day;
    }

    public static SolarDay fromYmd(int year, int month, int day) {
        return new SolarDay(year, month, day);
    }

    public SolarMonth getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public Week getWeek() {
        return this.getJulianDay().getWeek();
    }

    public Constellation getConstellation() {
        int index = 11;
        int y = this.month.getMonth() * 100 + this.day;
        if (y >= 321 && y <= 419) {
            index = 0;
        } else if (y >= 420 && y <= 520) {
            index = 1;
        } else if (y >= 521 && y <= 621) {
            index = 2;
        } else if (y >= 622 && y <= 722) {
            index = 3;
        } else if (y >= 723 && y <= 822) {
            index = 4;
        } else if (y >= 823 && y <= 922) {
            index = 5;
        } else if (y >= 923 && y <= 1023) {
            index = 6;
        } else if (y >= 1024 && y <= 1122) {
            index = 7;
        } else if (y >= 1123 && y <= 1221) {
            index = 8;
        } else if (y >= 1222 || y <= 119) {
            index = 9;
        } else if (y <= 218) {
            index = 10;
        }
        return Constellation.get(index);
    }

    @Override
    public String getName() {
        return NAMES[this.day - 1];
    }

    @Override
    public String toString() {
        return String.valueOf(this.month) + this.getName();
    }

    @Override
    public SolarDay next(int n) {
        return this.getJulianDay().next(n).getSolarDay();
    }

    public boolean isBefore(SolarDay target) {
        int bYear;
        SolarMonth bMonth = target.getMonth();
        int aYear = this.month.getYear().getYear();
        if (aYear != (bYear = bMonth.getYear().getYear())) {
            return aYear < bYear;
        }
        return this.month.getMonth() != bMonth.getMonth() ? this.month.getMonth() < bMonth.getMonth() : this.day < target.getDay();
    }

    public boolean isAfter(SolarDay target) {
        int bYear;
        SolarMonth bMonth = target.getMonth();
        int aYear = this.month.getYear().getYear();
        if (aYear != (bYear = bMonth.getYear().getYear())) {
            return aYear > bYear;
        }
        return this.month.getMonth() != bMonth.getMonth() ? this.month.getMonth() > bMonth.getMonth() : this.day > target.getDay();
    }

    public SolarTerms getTerm() {
        return this.getTermDay().getSolarTerm();
    }

    public SolarTermDay getTermDay() {
        SolarTerms term = SolarTerms.fromIndex(this.month.getYear().getYear() + 1, 0);
        SolarDay day = term.getJulianDay().getSolarDay();
        while (this.isBefore(day)) {
            term = term.next(-1);
            day = term.getJulianDay().getSolarDay();
        }
        return new SolarTermDay(term, this.subtract(day));
    }

    public SolarWeek getSolarWeek(int start) {
        int y = this.month.getYear().getYear();
        int m = this.month.getMonth();
        return SolarWeek.fromYm(y, m, (int)Math.ceil((double)(this.day + SolarDay.fromYmd(y, m, 1).getWeek().next(-start).getIndex()) / 7.0) - 1, start);
    }

    public ClimateDay getClimateDay() {
        SolarTerms term = this.getTerm();
        int dayIndex = this.subtract(term.getJulianDay().getSolarDay());
        int index = dayIndex / 5;
        if (index > 2) {
            index = 2;
        }
        return new ClimateDay(Climate.fromIndex(term.getIndex() * 3 + index), dayIndex -= index * 5);
    }

    public DogDay getDogDay() {
        int days;
        SolarTerms xiaZhi = SolarTerms.fromIndex(this.month.getYear().getYear(), 12);
        SolarDay start = xiaZhi.getJulianDay().getSolarDay();
        int add = 6 - start.getLunarDay().getSixtyCycle().getHeavenStem().getIndex();
        if (add < 0) {
            add += 10;
        }
        if ((days = this.subtract(start = start.next(add += 20))) < 0) {
            return null;
        }
        if (days < 10) {
            return new DogDay(Dog.fromIndex(0), days);
        }
        days = this.subtract(start = start.next(10));
        if (days < 10) {
            return new DogDay(Dog.fromIndex(1), days);
        }
        start = start.next(10);
        days = this.subtract(start);
        if (xiaZhi.next(3).getJulianDay().getSolarDay().isAfter(start)) {
            if (days < 10) {
                return new DogDay(Dog.fromIndex(1), days + 10);
            }
            start = start.next(10);
            days = this.subtract(start);
        }
        return days >= 10 ? null : new DogDay(Dog.fromIndex(2), days);
    }

    public NineDay getNineDay() {
        int year = this.month.getYear().getYear();
        SolarDay start = SolarTerms.fromIndex(year + 1, 0).getJulianDay().getSolarDay();
        if (this.isBefore(start)) {
            start = SolarTerms.fromIndex(year, 0).getJulianDay().getSolarDay();
        }
        SolarDay end = start.next(81);
        if (this.isBefore(start) || !this.isBefore(end)) {
            return null;
        }
        int days = this.subtract(start);
        return new NineDay(Nine.fromIndex(days / 9), days % 9);
    }

    public PlumRainDay getPlumRainDay() {
        SolarTerms grainInEar = SolarTerms.fromIndex(this.month.getYear().getYear(), 11);
        SolarDay start = grainInEar.getJulianDay().getSolarDay();
        int add = 2 - start.getLunarDay().getSixtyCycle().getHeavenStem().getIndex();
        if (add < 0) {
            add += 10;
        }
        start = start.next(add);
        SolarTerms slightHeat = grainInEar.next(2);
        SolarDay end = slightHeat.getJulianDay().getSolarDay();
        add = 7 - end.getLunarDay().getSixtyCycle().getEarthBranch().getIndex();
        if (add < 0) {
            add += 12;
        }
        end = end.next(add);
        if (this.isBefore(start) || this.isAfter(end)) {
            return null;
        }
        return this.equals(end) ? new PlumRainDay(PlumRain.fromIndex(1), 0) : new PlumRainDay(PlumRain.fromIndex(0), this.subtract(start));
    }

    public int getIndexInYear() {
        return this.subtract(SolarDay.fromYmd(this.month.getYear().getYear(), 1, 1));
    }

    public int subtract(SolarDay target) {
        return (int)(this.getJulianDay().getDay() - target.getJulianDay().getDay());
    }

    public JulianDay getJulianDay() {
        return JulianDay.fromYmdHms(this.month.getYear().getYear(), this.month.getMonth(), this.day, 0, 0, 0);
    }

    public LunarDay getLunarDay() {
        LunarMonth m = LunarMonth.fromYm(this.month.getYear().getYear(), this.month.getMonth()).next(-3);
        int days = this.subtract(m.getFirstJulianDay().getSolarDay());
        while (days >= m.getDayCount()) {
            m = m.next(1);
            days = this.subtract(m.getFirstJulianDay().getSolarDay());
        }
        return LunarDay.fromYmd(m.getYear().getYear(), m.getMonthWithLeap(), days + 1);
    }

    public Holiday getHoliday() {
        return Holiday.fromYmd(this.month.getYear().getYear(), this.month.getMonth(), this.day);
    }

    public SolarFestival getFestival() {
        return SolarFestival.fromYmd(this.month.getYear().getYear(), this.month.getMonth(), this.day);
    }
}

