/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.date.format.parser;

import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.miaixz.bus.core.center.date.builder.DateBuilder;
import org.miaixz.bus.core.center.date.culture.en.Month;
import org.miaixz.bus.core.center.date.culture.en.Week;
import org.miaixz.bus.core.center.date.format.parser.PredicateDateParser;
import org.miaixz.bus.core.lang.Optional;
import org.miaixz.bus.core.lang.exception.DateException;
import org.miaixz.bus.core.xyz.DateKit;
import org.miaixz.bus.core.xyz.PatternKit;
import org.miaixz.bus.core.xyz.StringKit;

public class RegexDateParser
implements PredicateDateParser {
    private static final int[] NSS = new int[]{100000000, 10000000, 1000000, 100000, 10000, 1000, 100, 10, 1};
    private final Pattern pattern;

    public RegexDateParser(Pattern pattern) {
        this.pattern = pattern;
    }

    public static RegexDateParser of(String regex) {
        return RegexDateParser.of(Pattern.compile(regex, 2));
    }

    public static RegexDateParser of(Pattern pattern) {
        return new RegexDateParser(pattern);
    }

    public static Date parse(Matcher matcher) throws DateException {
        String millisecond = PatternKit.group(matcher, "millisecond");
        if (StringKit.isNotEmpty(millisecond)) {
            return DateKit.date(RegexDateParser.parseLong(millisecond));
        }
        DateBuilder dateBuilder = DateBuilder.of();
        Optional.ofNullable(PatternKit.group(matcher, "year")).ifPresent(year -> dateBuilder.setYear(RegexDateParser.parseYear(year)));
        Optional.ofNullable(PatternKit.group(matcher, "month")).ifPresent(month -> dateBuilder.setMonth(RegexDateParser.parseMonth(month)));
        Optional.ofNullable(PatternKit.group(matcher, "week")).ifPresent(week -> dateBuilder.setWeek(RegexDateParser.parseWeek(week)));
        Optional.ofNullable(PatternKit.group(matcher, "day")).ifPresent(day -> dateBuilder.setDay(RegexDateParser.parseNumberLimit(day, 1, 31)));
        Optional.ofNullable(PatternKit.group(matcher, "hour")).ifPresent(hour -> dateBuilder.setHour(RegexDateParser.parseNumberLimit(hour, 0, 23)));
        Optional.ofNullable(PatternKit.group(matcher, "minute")).ifPresent(minute -> dateBuilder.setMinute(RegexDateParser.parseNumberLimit(minute, 0, 59)));
        Optional.ofNullable(PatternKit.group(matcher, "second")).ifPresent(second -> dateBuilder.setSecond(RegexDateParser.parseNumberLimit(second, 0, 59)));
        Optional.ofNullable(PatternKit.group(matcher, "ns")).ifPresent(ns -> dateBuilder.setNs(RegexDateParser.parseNano(ns)));
        Optional.ofNullable(PatternKit.group(matcher, "m")).ifPresent(m -> {
            if ('p' == m.charAt(0)) {
                dateBuilder.setPm(true);
            } else {
                dateBuilder.setAm(true);
            }
        });
        Optional.ofNullable(PatternKit.group(matcher, "zero")).ifPresent(zero -> {
            dateBuilder.setZoneOffsetSetted(true);
            dateBuilder.setZoneOffset(0);
        });
        Optional.ofNullable(PatternKit.group(matcher, "zoneOffset")).ifPresent(zoneOffset -> {
            dateBuilder.setZoneOffsetSetted(true);
            dateBuilder.setZoneOffset(RegexDateParser.parseZoneOffset(zoneOffset));
        });
        Optional.ofNullable(PatternKit.group(matcher, "unixsecond")).ifPresent(unixsecond -> dateBuilder.setUnixsecond(RegexDateParser.parseLong(unixsecond)));
        return dateBuilder.toDate();
    }

    private static int parseYear(String year) {
        int length = year.length();
        switch (length) {
            case 4: {
                return Integer.parseInt(year);
            }
            case 2: {
                int num = Integer.parseInt(year);
                return (num > 50 ? 1900 : 2000) + num;
            }
        }
        throw new DateException("Invalid year: [{}]", new Object[]{year});
    }

    private static int parseMonth(String month) {
        try {
            int monthInt = Integer.parseInt(month);
            if (monthInt > 0 && monthInt < 13) {
                return monthInt;
            }
        }
        catch (NumberFormatException e) {
            return Month.of(month).getIsoValue();
        }
        throw new DateException("Invalid month: [{}]", new Object[]{month});
    }

    private static int parseWeek(String week) {
        return Week.of(week).getIsoValue();
    }

    private static int parseNumberLimit(String numberStr, int minInclude, int maxInclude) {
        try {
            int monthInt = Integer.parseInt(numberStr);
            if (monthInt >= minInclude && monthInt <= maxInclude) {
                return monthInt;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new DateException("Invalid number: [{}]", new Object[]{numberStr});
    }

    private static long parseLong(String numberStr) {
        try {
            return Long.parseLong(numberStr);
        }
        catch (NumberFormatException numberFormatException) {
            throw new DateException("Invalid long: [{}]", new Object[]{numberStr});
        }
    }

    private static int parseInt(String numberStr, int from, int to) {
        try {
            return Integer.parseInt(numberStr.substring(from, to));
        }
        catch (NumberFormatException numberFormatException) {
            throw new DateException("Invalid int: [{}]", new Object[]{numberStr});
        }
    }

    private static int parseNano(String ns) {
        return NSS[ns.length() - 1] * Integer.parseInt(ns);
    }

    private static int parseZoneOffset(String zoneOffset) {
        int hour;
        boolean neg;
        int from = 0;
        int to = zoneOffset.length();
        boolean bl = neg = '-' == zoneOffset.charAt(from);
        if (++from + 2 <= to && Character.isDigit(zoneOffset.charAt(from + 1))) {
            hour = RegexDateParser.parseInt(zoneOffset, from, from + 2);
            from += 2;
        } else {
            hour = RegexDateParser.parseInt(zoneOffset, from, from + 1);
            ++from;
        }
        if (from + 3 <= to && zoneOffset.charAt(from) == ':') {
            ++from;
        }
        int minute = 0;
        if (from + 2 <= to) {
            minute = RegexDateParser.parseInt(zoneOffset, from, from + 2);
        }
        return (hour * 60 + minute) * (neg ? -1 : 1);
    }

    @Override
    public boolean test(CharSequence source) {
        return PatternKit.isMatch(this.pattern, source);
    }

    @Override
    public Date parse(CharSequence source) throws DateException {
        Matcher matcher = this.pattern.matcher(source);
        if (!matcher.matches()) {
            throw new DateException("Invalid date string: [{}], not match the date regex: [{}].", source, this.pattern.pattern());
        }
        return RegexDateParser.parse(matcher);
    }
}

