/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.map.multi;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.miaixz.bus.core.center.map.multi.SetValueMap;
import org.miaixz.bus.core.xyz.CollKit;

public class Graph<T>
extends SetValueMap<T, T> {
    private static final long serialVersionUID = -1L;

    public void putEdge(T target1, T target2) {
        this.putValue(target1, target2);
        this.putValue(target2, target1);
    }

    public boolean containsEdge(T target1, T target2) {
        return this.getValues(target1).contains(target2) && this.getValues(target2).contains(target1);
    }

    public void removeEdge(T target1, T target2) {
        this.removeValue(target1, target2);
        this.removeValue(target2, target1);
    }

    public void removePoint(T target) {
        Collection associatedPoints = (Collection)this.remove(target);
        if (CollKit.isNotEmpty(associatedPoints)) {
            associatedPoints.forEach((? super T p) -> this.removeValue(p, target));
        }
    }

    public boolean containsAssociation(T target1, T target2) {
        if (!this.containsKey(target1) || !this.containsKey(target2)) {
            return false;
        }
        AtomicBoolean flag = new AtomicBoolean(false);
        this.visitAssociatedPoints(target1, t -> {
            if (Objects.equals(t, target2)) {
                flag.set(true);
                return true;
            }
            return false;
        });
        return flag.get();
    }

    public Collection<T> getAssociatedPoints(T target, boolean includeTarget) {
        Set<Object> points = this.visitAssociatedPoints(target, t -> false);
        if (!includeTarget) {
            points.remove(target);
        }
        return points;
    }

    public Collection<T> getAdjacentPoints(T target) {
        return this.getValues(target);
    }

    private Set<T> visitAssociatedPoints(T key, Predicate<T> breaker) {
        if (!this.containsKey(key)) {
            return Collections.emptySet();
        }
        HashSet accessed = new HashSet();
        LinkedList<Object> deque = new LinkedList<Object>();
        deque.add(key);
        while (!deque.isEmpty()) {
            Object t = deque.removeFirst();
            if (accessed.contains(t)) continue;
            accessed.add(t);
            if (breaker.test(t)) break;
            Collection neighbours = this.getValues(t);
            if (neighbours.isEmpty()) continue;
            deque.addAll(neighbours);
        }
        return accessed;
    }
}

