/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.convert;

import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import org.miaixz.bus.core.center.date.DateTime;
import org.miaixz.bus.core.convert.AbstractConverter;
import org.miaixz.bus.core.lang.exception.ConvertException;
import org.miaixz.bus.core.xyz.DateKit;
import org.miaixz.bus.core.xyz.StringKit;

public class DateConverter
extends AbstractConverter {
    public static final DateConverter INSTANCE = new DateConverter();
    private static final long serialVersionUID = -1L;
    private String format;

    public DateConverter() {
        this(null);
    }

    public DateConverter(String format) {
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    protected Date convertInternal(Class<?> targetClass, Object value) {
        DateTime dateTime;
        if (value == null || value instanceof CharSequence && StringKit.isBlank(value.toString())) {
            return null;
        }
        if (value instanceof TemporalAccessor) {
            return this.wrap(targetClass, DateKit.date((TemporalAccessor)value));
        }
        if (value instanceof Calendar) {
            return this.wrap(targetClass, DateKit.date((Calendar)value));
        }
        if (null == this.format && value instanceof Number) {
            return this.wrap(targetClass, ((Number)value).longValue());
        }
        String valueStr = this.convertToString(value);
        DateTime dateTime2 = dateTime = StringKit.isBlank(this.format) ? DateKit.parse(valueStr) : DateKit.parse((CharSequence)valueStr, this.format);
        if (null != dateTime) {
            return this.wrap(targetClass, dateTime);
        }
        throw new ConvertException("Can not convert {}:[{}] to {}", value.getClass().getName(), value, targetClass.getName());
    }

    private Date wrap(Class<?> targetClass, DateTime date) {
        if (Date.class == targetClass) {
            return date.toJdkDate();
        }
        if (DateTime.class == targetClass) {
            return date;
        }
        return this.wrap(targetClass, date.getTime());
    }

    private Date wrap(Class<?> targetClass, long mills) {
        if (Date.class == targetClass) {
            return new Date(mills);
        }
        if (DateTime.class == targetClass) {
            return DateKit.date(mills);
        }
        return DateKit.SQL.wrap(targetClass, mills);
    }
}

