/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.convert;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Map;
import org.miaixz.bus.core.beans.copier.ValueProvider;
import org.miaixz.bus.core.beans.copier.provider.BeanValueProvider;
import org.miaixz.bus.core.beans.copier.provider.MapValueProvider;
import org.miaixz.bus.core.convert.Converter;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.exception.ConvertException;
import org.miaixz.bus.core.xyz.BeanKit;
import org.miaixz.bus.core.xyz.KotlinKit;
import org.miaixz.bus.core.xyz.TypeKit;

public class KotlinBeanConverter
implements Converter,
Serializable {
    private static final long serialVersionUID = -1L;
    public static KotlinBeanConverter INSTANCE = new KotlinBeanConverter();

    @Override
    public Object convert(Type targetType, Object value) throws ConvertException {
        Assert.notNull(targetType);
        if (null == value) {
            return null;
        }
        if (value instanceof Converter) {
            return ((Converter)value).convert(targetType, value);
        }
        Class<?> targetClass = TypeKit.getClass(targetType);
        Assert.notNull(targetClass, "Target type is not a class!", new Object[0]);
        return this.convertInternal(targetType, targetClass, value);
    }

    private Object convertInternal(Type targetType, Class<?> targetClass, Object value) {
        ValueProvider valueProvider = null;
        if (value instanceof ValueProvider) {
            valueProvider = (ValueProvider)value;
        } else if (value instanceof Map) {
            valueProvider = new MapValueProvider((Map)value);
        } else if (BeanKit.isWritableBean(value.getClass())) {
            valueProvider = new BeanValueProvider(value);
        }
        if (null != valueProvider) {
            return KotlinKit.newInstance(targetClass, valueProvider);
        }
        throw new ConvertException("Unsupported source type: [{}] to [{}]", value.getClass(), targetType);
    }
}

