/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.convert;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.miaixz.bus.core.convert.CompositeConverter;
import org.miaixz.bus.core.convert.Converter;
import org.miaixz.bus.core.lang.exception.ConvertException;
import org.miaixz.bus.core.lang.reflect.TypeReference;
import org.miaixz.bus.core.xyz.BeanKit;
import org.miaixz.bus.core.xyz.MapKit;
import org.miaixz.bus.core.xyz.TypeKit;

public class MapConverter
implements Converter,
Serializable {
    private static final long serialVersionUID = -1L;
    public static MapConverter INSTANCE = new MapConverter();

    @Override
    public Object convert(Type targetType, Object value) throws ConvertException {
        if (targetType instanceof TypeReference) {
            targetType = ((TypeReference)targetType).getType();
        }
        Type keyType = TypeKit.getTypeArgument(targetType, 0);
        Type valueType = TypeKit.getTypeArgument(targetType, 1);
        return this.convert(targetType, keyType, valueType, value);
    }

    public Map<?, ?> convert(Type targetType, Type keyType, Type valueType, Object value) throws ConvertException {
        Map<String, Object> map;
        if (value instanceof Map) {
            Type[] typeArguments;
            Class<?> valueClass = value.getClass();
            if (valueClass.equals(targetType) && null != (typeArguments = TypeKit.getTypeArguments(valueClass)) && 2 == typeArguments.length && Objects.equals(keyType, typeArguments[0]) && Objects.equals(valueType, typeArguments[1])) {
                return (Map)value;
            }
            map = MapKit.createMap(TypeKit.getClass(targetType), LinkedHashMap::new);
            this.convertMapToMap(keyType, valueType, (Map)value, map);
        } else if (BeanKit.isWritableBean(value.getClass())) {
            map = BeanKit.beanToMap(value, new String[0]);
            map = this.convert(targetType, keyType, valueType, map);
        } else {
            throw new ConvertException("Unsupported to map from [{}] of type: {}", value, value.getClass().getName());
        }
        return map;
    }

    private void convertMapToMap(Type keyType, Type valueType, Map<?, ?> srcMap, Map targetMap) {
        CompositeConverter convert = CompositeConverter.getInstance();
        srcMap.forEach((key, value) -> targetMap.put(TypeKit.isUnknown(keyType) ? key : convert.convert(keyType, key), TypeKit.isUnknown(valueType) ? value : convert.convert(valueType, value)));
    }
}

