/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.convert;

import java.lang.reflect.Type;
import java.util.Map;
import org.miaixz.bus.core.convert.CompositeConverter;
import org.miaixz.bus.core.convert.Converter;
import org.miaixz.bus.core.lang.exception.ConvertException;
import org.miaixz.bus.core.lang.reflect.TypeReference;
import org.miaixz.bus.core.lang.tuple.Pair;
import org.miaixz.bus.core.xyz.BeanKit;
import org.miaixz.bus.core.xyz.MapKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.core.xyz.TypeKit;

public class PairConverter
implements Converter {
    public static final PairConverter INSTANCE = new PairConverter();

    private static Map<CharSequence, CharSequence> strToMap(CharSequence text) {
        int index = StringKit.indexOf(text, c -> c.charValue() == ':' || c.charValue() == '=' || c.charValue() == ',', 0, text.length());
        if (index > -1) {
            return MapKit.of(text.subSequence(0, index), text.subSequence(index + 1, text.length()));
        }
        return null;
    }

    private static Pair<?, ?> mapToPair(Type keyType, Type valueType, Map map) {
        Object left = null;
        Object right = null;
        if (1 == map.size()) {
            Map.Entry entry = map.entrySet().iterator().next();
            left = entry.getKey();
            right = entry.getValue();
        } else if (2 == map.size()) {
            left = map.get("left");
            right = map.get("right");
        }
        CompositeConverter convert = CompositeConverter.getInstance();
        return Pair.of(TypeKit.isUnknown(keyType) ? left : convert.convert(keyType, left), TypeKit.isUnknown(valueType) ? right : convert.convert(valueType, right));
    }

    @Override
    public Object convert(Type targetType, Object value) throws ConvertException {
        if (targetType instanceof TypeReference) {
            targetType = ((TypeReference)targetType).getType();
        }
        Type leftType = TypeKit.getTypeArgument(targetType, 0);
        Type rightType = TypeKit.getTypeArgument(targetType, 1);
        return this.convert(leftType, rightType, value);
    }

    public Pair<?, ?> convert(Type leftType, Type rightType, Object value) throws ConvertException {
        Map<Object, Object> map = null;
        if (value instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)value;
            map = MapKit.of(entry.getKey(), entry.getValue());
        } else if (value instanceof Pair) {
            Pair entry = (Pair)value;
            map = MapKit.of(entry.getLeft(), entry.getRight());
        } else if (value instanceof Map) {
            map = (Map)value;
        } else if (value instanceof CharSequence) {
            map = PairConverter.strToMap((CharSequence)value);
        } else if (BeanKit.isReadableBean(value.getClass())) {
            map = BeanKit.beanToMap(value, new String[0]);
        }
        if (null != map) {
            return PairConverter.mapToPair(leftType, rightType, map);
        }
        throw new ConvertException("Unsupported to map from [{}] of type: {}", value, value.getClass().getName());
    }
}

