/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.convert.stringer;

import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.function.Function;
import org.miaixz.bus.core.convert.stringer.ClobStringer;
import org.miaixz.bus.core.lang.Charset;
import org.miaixz.bus.core.lang.exception.ConvertException;
import org.miaixz.bus.core.xyz.IoKit;

public class BlobStringer
implements Function<Object, String> {
    public static ClobStringer INSTANCE = new ClobStringer();

    private static String toString(Blob blob) {
        String string;
        InputStream in = null;
        try {
            in = blob.getBinaryStream();
            string = IoKit.read(in, Charset.UTF_8);
        }
        catch (SQLException e) {
            try {
                throw new ConvertException(e);
            }
            catch (Throwable throwable) {
                IoKit.closeQuietly(in);
                throw throwable;
            }
        }
        IoKit.closeQuietly(in);
        return string;
    }

    @Override
    public String apply(Object o) {
        return BlobStringer.toString((Blob)o);
    }
}

