/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.data.id;

import java.io.Serializable;
import java.util.Date;
import org.miaixz.bus.core.center.date.NonClock;
import org.miaixz.bus.core.data.id.ID;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.tuple.Pair;
import org.miaixz.bus.core.xyz.RandomKit;

public class Snowflake
implements Serializable {
    public static final long DEFAULT_TWEPOCH = 1288834974657L;
    private static final long serialVersionUID = -1L;
    private static final long WORKER_ID_BITS = 5L;
    private static final long MAX_WORKER_ID = 31L;
    private static final long DATA_CENTER_ID_BITS = 5L;
    private static final long MAX_DATA_CENTER_ID = 31L;
    private static final long SEQUENCE_BITS = 12L;
    private static final long WORKER_ID_SHIFT = 12L;
    private static final long DATA_CENTER_ID_SHIFT = 17L;
    private static final long TIMESTAMP_LEFT_SHIFT = 22L;
    private static final long SEQUENCE_MASK = 4095L;
    private final long twepoch;
    private final long workerId;
    private final long dataCenterId;
    private final boolean useSystemClock;
    private final long randomSequenceLimit;
    private long sequence = 0L;
    private long lastTimestamp = -1L;

    public Snowflake() {
        this(ID.getWorkerId(ID.getDataCenterId(31L), 31L));
    }

    public Snowflake(long workerId) {
        this(workerId, ID.getDataCenterId(31L));
    }

    public Snowflake(long workerId, long dataCenterId) {
        this(workerId, dataCenterId, false);
    }

    public Snowflake(long workerId, long dataCenterId, boolean isUseSystemClock) {
        this(null, workerId, dataCenterId, isUseSystemClock);
    }

    public Snowflake(Date epochDate, long workerId, long dataCenterId, boolean isUseSystemClock) {
        this(epochDate, workerId, dataCenterId, isUseSystemClock, 0L);
    }

    public Snowflake(Date epochDate, long workerId, long dataCenterId, boolean isUseSystemClock, long randomSequenceLimit) {
        this.twepoch = null != epochDate ? epochDate.getTime() : 1288834974657L;
        this.workerId = Assert.checkBetween(workerId, 0L, 31L);
        this.dataCenterId = Assert.checkBetween(dataCenterId, 0L, 31L);
        this.useSystemClock = isUseSystemClock;
        this.randomSequenceLimit = Assert.checkBetween(randomSequenceLimit, 0L, 4095L);
    }

    public long getWorkerId(long id) {
        return id >> 12 & 0x1FL;
    }

    public long getDataCenterId(long id) {
        return id >> 17 & 0x1FL;
    }

    public long getGenerateDateTime(long id) {
        return (id >> 22 & 0x1FFFFFFFFFFL) + this.twepoch;
    }

    public synchronized Long next() {
        long timestamp = this.genTime();
        if (timestamp < this.lastTimestamp) {
            timestamp = this.lastTimestamp;
        }
        if (timestamp == this.lastTimestamp) {
            long sequence = this.sequence + 1L & 0xFFFL;
            if (sequence == 0L) {
                ++timestamp;
            }
            this.sequence = sequence;
        } else {
            this.sequence = this.randomSequenceLimit > 1L ? RandomKit.randomLong(this.randomSequenceLimit) : 0L;
        }
        this.lastTimestamp = timestamp;
        return timestamp - this.twepoch << 22 | this.dataCenterId << 17 | this.workerId << 12 | this.sequence;
    }

    public String nextString() {
        return Long.toString(this.next());
    }

    public Pair<Long, Long> getIdScopeByTimestamp(long timestampStart, long timestampEnd) {
        return this.getIdScopeByTimestamp(timestampStart, timestampEnd, true);
    }

    public Pair<Long, Long> getIdScopeByTimestamp(long timestampStart, long timestampEnd, boolean ignoreCenterAndWorker) {
        long startTimeMinId = timestampStart - this.twepoch << 22;
        long endTimeMinId = timestampEnd - this.twepoch << 22;
        if (ignoreCenterAndWorker) {
            long endId = endTimeMinId | 0x3FFFFFL;
            return Pair.of(startTimeMinId, endId);
        }
        long startId = startTimeMinId | this.dataCenterId << 17 | this.workerId << 12;
        long endId = endTimeMinId | this.dataCenterId << 17 | this.workerId << 12 | 0xFFFL;
        return Pair.of(startId, endId);
    }

    private long genTime() {
        return this.useSystemClock ? NonClock.now() : System.currentTimeMillis();
    }
}

