/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.io;

import java.io.Writer;

public final class FastStringWriter
extends Writer {
    private static final int DEFAULT_CAPACITY = 16;
    private final StringBuilder stringBuilder;

    public FastStringWriter() {
        this(16);
    }

    public FastStringWriter(int initialSize) {
        if (initialSize < 0) {
            initialSize = 16;
        }
        this.stringBuilder = new StringBuilder(initialSize);
    }

    @Override
    public FastStringWriter append(char c) {
        this.stringBuilder.append(c);
        return this;
    }

    @Override
    public FastStringWriter append(CharSequence csq, int start, int end) {
        this.stringBuilder.append(csq, start, end);
        return this;
    }

    @Override
    public FastStringWriter append(CharSequence csq) {
        this.stringBuilder.append(csq);
        return this;
    }

    @Override
    public void write(int c) {
        this.stringBuilder.append((char)c);
    }

    @Override
    public void write(String text) {
        this.stringBuilder.append(text);
    }

    @Override
    public void write(String text, int off, int len) {
        this.stringBuilder.append(text, off, off + len);
    }

    @Override
    public void write(char[] c) {
        this.stringBuilder.append(c, 0, c.length);
    }

    @Override
    public void write(char[] c, int off, int len) {
        if (off < 0 || off > c.length || len < 0 || off + len > c.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.stringBuilder.append(c, off, len);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    public String toString() {
        return this.stringBuilder.toString();
    }
}

