/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.io.file;

import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import org.miaixz.bus.core.io.file.PathResolve;
import org.miaixz.bus.core.io.file.visitor.DeleteVisitor;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.exception.InternalException;

public class PathRemover {
    private final Path path;

    public PathRemover(Path path) {
        this.path = Assert.notNull(path, "Path must be not null !", new Object[0]);
    }

    public static PathRemover of(Path src) {
        return new PathRemover(src);
    }

    private static void remove(Path path) {
        try {
            Files.walkFileTree(path, DeleteVisitor.INSTANCE);
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    private static void removeFile(Path path) throws InternalException {
        try {
            Files.delete(path);
        }
        catch (IOException e) {
            if (e instanceof AccessDeniedException && path.toFile().delete()) {
                return;
            }
            throw new InternalException(e);
        }
    }

    public void remove() throws InternalException {
        Path path = this.path;
        if (Files.notExists(path, new LinkOption[0])) {
            return;
        }
        if (PathResolve.isDirectory(path)) {
            PathRemover.remove(path);
        } else {
            PathRemover.removeFile(path);
        }
    }

    public void clean() {
        try (Stream<Path> list = Files.list(this.path);){
            list.forEach(PathResolve::remove);
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }
}

