/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.io.resource;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import javax.tools.FileObject;
import org.miaixz.bus.core.io.resource.Resource;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.core.xyz.UrlKit;

public class FileObjectResource
implements Resource {
    private final FileObject fileObject;

    public FileObjectResource(FileObject fileObject) {
        this.fileObject = fileObject;
    }

    public FileObject getFileObject() {
        return this.fileObject;
    }

    @Override
    public String getName() {
        return this.fileObject.getName();
    }

    @Override
    public URL getUrl() {
        try {
            return this.fileObject.toUri().toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public long size() {
        return UrlKit.size(this.getUrl());
    }

    @Override
    public InputStream getStream() {
        try {
            return this.fileObject.openInputStream();
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    @Override
    public BufferedReader getReader(Charset charset) {
        try {
            return IoKit.toBuffered(this.fileObject.openReader(false));
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }
}

