/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.io.stream;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.miaixz.bus.core.lang.exception.InternalException;

public class LineCounter
implements Closeable {
    private final InputStream is;
    private final int bufferSize;
    private int count = -1;

    public LineCounter(InputStream is, int bufferSize) {
        this.is = is;
        this.bufferSize = bufferSize < 1 ? 1024 : bufferSize;
    }

    public int getCount() {
        if (this.count < 0) {
            try {
                this.count = this.count();
            }
            catch (IOException e) {
                throw new InternalException(e);
            }
        }
        return this.count;
    }

    @Override
    public void close() throws IOException {
        if (null != this.is) {
            this.is.close();
        }
    }

    private int count() throws IOException {
        int i;
        byte[] c = new byte[this.bufferSize];
        int readChars = this.is.read(c);
        if (readChars == -1) {
            return 0;
        }
        int count = 1;
        while (readChars == this.bufferSize) {
            for (i = 0; i < this.bufferSize; ++i) {
                if (c[i] != 10) continue;
                ++count;
            }
            readChars = this.is.read(c);
        }
        while (readChars != -1) {
            for (i = 0; i < readChars; ++i) {
                if (c[i] != 10) continue;
                ++count;
            }
            readChars = this.is.read(c);
        }
        return count;
    }
}

