/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.net.ip;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Matcher;
import org.miaixz.bus.core.center.regex.Pattern;
import org.miaixz.bus.core.instance.Instances;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.net.MaskBit;
import org.miaixz.bus.core.text.CharsBacker;
import org.miaixz.bus.core.xyz.CollKit;
import org.miaixz.bus.core.xyz.ListKit;
import org.miaixz.bus.core.xyz.NetKit;
import org.miaixz.bus.core.xyz.PatternKit;
import org.miaixz.bus.core.xyz.StringKit;

public class IPv4 {
    public static final long LOCAL_IP_NUM = IPv4.ipv4ToLong("127.0.0.1");
    public static final long IPV4_NUM_MIN = IPv4.ipv4ToLong("0.0.0.0");
    public static final long IPV4_UNUSED_NUM_MIN = IPv4.ipv4ToLong("0.0.0.0");
    public static final long IPV4_UNUSED_NUM_MAX = IPv4.ipv4ToLong("0.255.255.255");
    public static final int IPV4_MASK_BIT_MIN = 0;
    public static final int IPV4_MASK_BIT_VALID_MIN = 1;
    public static final String IPV4_MASK_VALID_MIN = MaskBit.get(1);
    public static final int IPV4_MASK_BIT_MAX = 32;
    public static final String IPV4_MASK_MAX = MaskBit.get(32);
    public static final String IPV4_LOOPBACK_STR_MIN = "127.0.0.0";
    public static final long IPV4_LOOPBACK_NUM_MIN = IPv4.ipv4ToLong("127.0.0.0");
    public static final String IPV4_LOOPBACK_STR_MAX = "127.255.255.255";
    public static final long IPV4_LOOPBACK_NUM_MAX = IPv4.ipv4ToLong("127.255.255.255");
    public static final String IPV4_A_STR_MIN = "0.0.0.0";
    public static final long IPV4_A_NUM_MIN = IPv4.ipv4ToLong("0.0.0.0");
    public static final String IPV4_A_STR_MAX = "127.255.255.255";
    public static final long IPV4_A_NUM_MAX = IPv4.ipv4ToLong("127.255.255.255");
    public static final String IPV4_A_PUBLIC_1_STR_MIN = "1.0.0.0";
    public static final long IPV4_A_PUBLIC_1_NUM_MIN = IPv4.ipv4ToLong("1.0.0.0");
    public static final String IPV4_A_PUBLIC_1_STR_MAX = "9.255.255.255";
    public static final long IPV4_A_PUBLIC_1_NUM_MAX = IPv4.ipv4ToLong("9.255.255.255");
    public static final String IPV4_A_PRIVATE_STR_MIN = "10.0.0.0";
    public static final long IPV4_A_PRIVATE_NUM_MIN = IPv4.ipv4ToLong("10.0.0.0");
    public static final String IPV4_A_PRIVATE_STR_MAX = "10.255.255.255";
    public static final long IPV4_A_PRIVATE_NUM_MAX = IPv4.ipv4ToLong("10.255.255.255");
    public static final String IPV4_A_PUBLIC_2_STR_MIN = "11.0.0.0";
    public static final long IPV4_A_PUBLIC_2_NUM_MIN = IPv4.ipv4ToLong("11.0.0.0");
    public static final String IPV4_A_PUBLIC_2_STR_MAX = "126.255.255.255";
    public static final long IPV4_A_PUBLIC_2_NUM_MAX = IPv4.ipv4ToLong("126.255.255.255");
    public static final String IPV4_B_STR_MIN = "128.0.0.0";
    public static final long IPV4_B_NUM_MIN = IPv4.ipv4ToLong("128.0.0.0");
    public static final String IPV4_B_STR_MAX = "191.255.255.255";
    public static final long IPV4_B_NUM_MAX = IPv4.ipv4ToLong("191.255.255.255");
    public static final String IPV4_B_PUBLIC_1_STR_MIN = "128.0.0.0";
    public static final long IPV4_B_PUBLIC_1_NUM_MIN = IPv4.ipv4ToLong("128.0.0.0");
    public static final String IPV4_B_PUBLIC_1_STR_MAX = "172.15.255.255";
    public static final long IPV4_B_PUBLIC_1_NUM_MAX = IPv4.ipv4ToLong("172.15.255.255");
    public static final String IPV4_B_PRIVATE_STR_MIN = "172.16.0.0";
    public static final long IPV4_B_PRIVATE_NUM_MIN = IPv4.ipv4ToLong("172.16.0.0");
    public static final String IPV4_B_PRIVATE_STR_MAX = "172.31.255.255";
    public static final long IPV4_B_PRIVATE_NUM_MAX = IPv4.ipv4ToLong("172.31.255.255");
    public static final String IPV4_B_PUBLIC_2_STR_MIN = "172.32.0.0";
    public static final long IPV4_B_PUBLIC_2_NUM_MIN = IPv4.ipv4ToLong("172.32.0.0");
    public static final String IPV4_B_PUBLIC_2_STR_MAX = "191.255.255.255";
    public static final long IPV4_B_PUBLIC_2_NUM_MAX = IPv4.ipv4ToLong("191.255.255.255");
    public static final String IPV4_C_STR_MIN = "192.0.0.0";
    public static final long IPV4_C_NUM_MIN = IPv4.ipv4ToLong("192.0.0.0");
    public static final String IPV4_C_STR_MAX = "223.255.255.255";
    public static final String IPV4_C_PUBLIC_1_STR_MIN = "192.0.0.0";
    public static final long IPV4_C_PUBLIC_1_NUM_MIN = IPv4.ipv4ToLong("192.0.0.0");
    public static final String IPV4_C_PUBLIC_1_STR_MAX = "192.167.255.255";
    public static final long IPV4_C_PUBLIC_1_NUM_MAX = IPv4.ipv4ToLong("192.167.255.255");
    public static final String IPV4_C_PRIVATE_STR_MIN = "192.168.0.0";
    public static final long IPV4_C_PRIVATE_NUM_MIN = IPv4.ipv4ToLong("192.168.0.0");
    public static final String IPV4_C_PRIVATE_STR_MAX = "192.168.255.255";
    public static final long IPV4_C_PRIVATE_NUM_MAX = IPv4.ipv4ToLong("192.168.255.255");
    public static final String IPV4_C_PUBLIC_2_STR_MIN = "192.169.0.0";
    public static final long IPV4_C_PUBLIC_2_NUM_MIN = IPv4.ipv4ToLong("192.169.0.0");
    public static final String IPV4_C_PUBLIC_2_STR_MAX = "223.255.255.255";
    public static final long IPV4_C_PUBLIC_2_NUM_MAX = IPv4.ipv4ToLong("223.255.255.255");
    public static final String IPV4_D_STR_MIN = "224.0.0.0";
    public static final long IPV4_D_NUM_MIN = IPv4.ipv4ToLong("224.0.0.0");
    public static final String IPV4_D_STR_MAX = "239.255.255.255";
    public static final long IPV4_D_NUM_MAX = IPv4.ipv4ToLong("239.255.255.255");
    public static final String IPV4_D_DEDICATED_STR_MIN = "224.0.0.0";
    public static final long IPV4_D_DEDICATED_NUM_MIN = IPv4.ipv4ToLong("224.0.0.0");
    public static final String IPV4_D_DEDICATED_STR_MAX = "224.0.0.255";
    public static final long IPV4_D_DEDICATED_NUM_MAX = IPv4.ipv4ToLong("224.0.0.255");
    public static final String IPV4_D_PUBLIC_STR_MIN = "224.0.1.0";
    public static final long IPV4_D_PUBLIC_NUM_MIN = IPv4.ipv4ToLong("224.0.1.0");
    public static final String IPV4_D_PUBLIC_STR_MAX = "238.255.255.255";
    public static final long IPV4_D_PUBLIC_NUM_MAX = IPv4.ipv4ToLong("238.255.255.255");
    public static final String IPV4_D_PRIVATE_STR_MIN = "239.0.0.0";
    public static final long IPV4_D_PRIVATE_NUM_MIN = IPv4.ipv4ToLong("239.0.0.0");
    public static final String IPV4_D_PRIVATE_STR_MAX = "239.255.255.255";
    public static final long IPV4_D_PRIVATE_NUM_MAX = IPv4.ipv4ToLong("239.255.255.255");
    public static final String IPV4_E_STR_MIN = "240.0.0.0";
    public static final long IPV4_E_NUM_MIN = IPv4.ipv4ToLong("240.0.0.0");
    public static final String IPV4_E_STR_MAX = "255.255.255.255";
    public static final long IPV4_E_NUM_MAX = IPv4.ipv4ToLong("255.255.255.255");
    private static volatile String localhostName;
    long IPV4_C_NUM_MAX = IPv4.ipv4ToLong("223.255.255.255");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getLocalHostName() {
        if (null != localhostName) return localhostName;
        Class<IPv4> clazz = IPv4.class;
        synchronized (IPv4.class) {
            if (null != localhostName) return localhostName;
            localhostName = NetKit.getAddressName(IPv4.getLocalhostDirectly());
            // ** MonitorExit[var0] (shouldn't be in output)
            return localhostName;
        }
    }

    public static String getLocalMacAddress() {
        return NetKit.getMacAddress(IPv4.getLocalhost());
    }

    public static byte[] getLocalHardwareAddress() {
        return NetKit.getHardwareAddress(IPv4.getLocalhost());
    }

    public static InetAddress getLocalhost() {
        return Instances.get(IPv4.class.getName(), IPv4::getLocalhostDirectly);
    }

    public static InetAddress getLocalhostDirectly() {
        return IPv4.getLocalhostDirectly(false);
    }

    public static InetAddress getLocalhostDirectly(boolean includeSiteLocal) {
        LinkedHashSet<InetAddress> localAddressList = NetKit.localAddressList(address -> address instanceof Inet4Address && !address.isLoopbackAddress() && (includeSiteLocal || !address.isSiteLocalAddress()) && !address.isLinkLocalAddress());
        if (CollKit.isNotEmpty(localAddressList)) {
            return CollKit.getFirst(localAddressList);
        }
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            if (localHost instanceof Inet4Address) {
                return localHost;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return null;
    }

    public static InetSocketAddress buildInetSocketAddress(String host, int defaultPort) {
        int port;
        String targetHost;
        int index;
        if (StringKit.isBlank(host)) {
            host = "127.0.0.1";
        }
        if ((index = host.indexOf(":")) != -1) {
            targetHost = host.substring(0, index);
            port = Integer.parseInt(host.substring(index + 1));
        } else {
            targetHost = host;
            port = defaultPort;
        }
        return new InetSocketAddress(targetHost, port);
    }

    public static String formatIpBlock(String ip, String mask) {
        return ip + "/" + IPv4.getMaskBitByMask(mask);
    }

    public static List<String> list(String ipRange, boolean isAll) {
        if (ipRange.contains("-")) {
            String[] range = CharsBacker.splitToArray(ipRange, "-");
            return IPv4.list(range[0], range[1]);
        }
        if (ipRange.contains("/")) {
            String[] param = CharsBacker.splitToArray(ipRange, "/");
            return IPv4.list(param[0], Integer.parseInt(param[1]), isAll);
        }
        return ListKit.of(ipRange);
    }

    public static List<String> list(String ip, int maskBit, boolean isAll) {
        IPv4.assertMaskBitValid(maskBit);
        if (IPv4.countByMaskBit(maskBit, isAll) == 0) {
            return ListKit.zero();
        }
        long startIp = IPv4.getBeginIpLong(ip, maskBit);
        long endIp = IPv4.getEndIpLong(ip, maskBit);
        if (isAll) {
            return IPv4.list(startIp, endIp);
        }
        if (startIp + 1L > endIp - 1L) {
            return ListKit.zero();
        }
        return IPv4.list(startIp + 1L, endIp - 1L);
    }

    public static List<String> list(String ipFrom, String ipTo) {
        return IPv4.list(IPv4.ipv4ToLong(ipFrom), IPv4.ipv4ToLong(ipTo));
    }

    public static List<String> list(long ipFrom, long ipTo) {
        int count = IPv4.countByIpRange(ipFrom, ipTo);
        ArrayList<String> ips = new ArrayList<String>(count);
        StringBuilder sb = StringKit.builder(15);
        long end = ipTo + 1L;
        for (long ip = ipFrom; ip < end; ++ip) {
            sb.setLength(0);
            ips.add(sb.append((int)(ip >> 24) & 0xFF).append('.').append((int)(ip >> 16) & 0xFF).append('.').append((int)(ip >> 8) & 0xFF).append('.').append((int)ip & 0xFF).toString());
        }
        return ips;
    }

    public static String longToIpv4(long ip) {
        return StringKit.builder(15).append((int)(ip >> 24) & 0xFF).append('.').append((int)(ip >> 16) & 0xFF).append('.').append((int)(ip >> 8) & 0xFF).append('.').append((int)ip & 0xFF).toString();
    }

    public static long ipv4ToLong(String strIp) {
        Matcher matcher = Pattern.IPV4_PATTERN.matcher(strIp);
        Assert.isTrue(matcher.matches(), "Invalid IPv4 address: {}", strIp);
        return IPv4.matchAddress(matcher);
    }

    public static String getBeginIpString(String ip, int maskBit) {
        return IPv4.longToIpv4(IPv4.getBeginIpLong(ip, maskBit));
    }

    public static long getBeginIpLong(String ip, int maskBit) {
        IPv4.assertMaskBitValid(maskBit);
        return IPv4.ipv4ToLong(ip) & MaskBit.getMaskIpLong(maskBit);
    }

    public static String getEndIpString(String ip, int maskBit) {
        return IPv4.longToIpv4(IPv4.getEndIpLong(ip, maskBit));
    }

    public static long getEndIpLong(String ip, int maskBit) {
        return IPv4.getBeginIpLong(ip, maskBit) + (0xFFFFFFFFL & (MaskBit.getMaskIpLong(maskBit) ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public static int getMaskBitByMask(String mask) {
        Integer maskBit = MaskBit.getMaskBit(mask);
        Assert.notNull(maskBit, "Invalid netmask\uff1a{}", mask);
        return maskBit;
    }

    public static int countByMaskBit(int maskBit, boolean isAll) {
        Assert.isTrue(maskBit > 1 && maskBit <= 32, "Not support mask bit: {}", maskBit);
        if (maskBit == 32 && !isAll) {
            return 0;
        }
        int count = 1 << 32 - maskBit;
        return isAll ? count : count - 2;
    }

    public static String getMaskByMaskBit(int maskBit) {
        IPv4.assertMaskBitValid(maskBit);
        return MaskBit.get(maskBit);
    }

    public static String getMaskByIpRange(String fromIp, String toIp) {
        long toIpLong = IPv4.ipv4ToLong(toIp);
        long fromIpLong = IPv4.ipv4ToLong(fromIp);
        Assert.isTrue(fromIpLong <= toIpLong, "Start IP must be less than or equal to end IP!", new Object[0]);
        return StringKit.builder(15).append(255 - IPv4.getPartOfIp(toIpLong, 1) + IPv4.getPartOfIp(fromIpLong, 1)).append('.').append(255 - IPv4.getPartOfIp(toIpLong, 2) + IPv4.getPartOfIp(fromIpLong, 2)).append('.').append(255 - IPv4.getPartOfIp(toIpLong, 3) + IPv4.getPartOfIp(fromIpLong, 3)).append('.').append(255 - IPv4.getPartOfIp(toIpLong, 4) + IPv4.getPartOfIp(fromIpLong, 4)).toString();
    }

    public static int countByIpRange(String fromIp, String toIp) {
        return IPv4.countByIpRange(IPv4.ipv4ToLong(fromIp), IPv4.ipv4ToLong(toIp));
    }

    public static int countByIpRange(long fromIp, long toIp) {
        Assert.isTrue(fromIp <= toIp, "Start IP must be less than or equal to end IP!", new Object[0]);
        int count = 1;
        return count += IPv4.getPartOfIp(toIp, 4) - IPv4.getPartOfIp(fromIp, 4) + (IPv4.getPartOfIp(toIp, 3) - IPv4.getPartOfIp(fromIp, 3) << 8) + (IPv4.getPartOfIp(toIp, 2) - IPv4.getPartOfIp(fromIp, 2) << 16) + (IPv4.getPartOfIp(toIp, 1) - IPv4.getPartOfIp(fromIp, 1) << 24);
    }

    public static boolean isMaskValid(String mask) {
        return MaskBit.getMaskBit(mask) != null;
    }

    public static boolean isMaskBitValid(int maskBit) {
        return maskBit >= 1 && maskBit <= 32;
    }

    public static boolean isInnerIP(String ipAddress) {
        return IPv4.isInnerIP(IPv4.ipv4ToLong(ipAddress));
    }

    public static boolean isInnerIP(long ipNum) {
        return IPv4.isBetween(ipNum, IPV4_A_PRIVATE_NUM_MIN, IPV4_A_PRIVATE_NUM_MAX) || IPv4.isBetween(ipNum, IPV4_B_PRIVATE_NUM_MIN, IPV4_B_PRIVATE_NUM_MAX) || IPv4.isBetween(ipNum, IPV4_C_PRIVATE_NUM_MIN, IPV4_C_PRIVATE_NUM_MAX) || LOCAL_IP_NUM == ipNum;
    }

    public static boolean isPublicIP(String ipAddress) {
        return IPv4.isPublicIP(IPv4.ipv4ToLong(ipAddress));
    }

    public static boolean isPublicIP(long ipNum) {
        return IPv4.isBetween(ipNum, IPV4_A_PUBLIC_1_NUM_MIN, IPV4_A_PUBLIC_1_NUM_MAX) || IPv4.isBetween(ipNum, IPV4_A_PUBLIC_2_NUM_MIN, IPV4_A_PUBLIC_2_NUM_MAX) || IPv4.isBetween(ipNum, IPV4_B_PUBLIC_1_NUM_MIN, IPV4_B_PUBLIC_1_NUM_MAX) || IPv4.isBetween(ipNum, IPV4_B_PUBLIC_2_NUM_MIN, IPV4_B_PUBLIC_2_NUM_MAX) || IPv4.isBetween(ipNum, IPV4_C_PUBLIC_1_NUM_MIN, IPV4_C_PUBLIC_1_NUM_MAX) || IPv4.isBetween(ipNum, IPV4_C_PUBLIC_2_NUM_MIN, IPV4_C_PUBLIC_2_NUM_MAX);
    }

    public static int getPartOfIp(long ip, int position) {
        switch (position) {
            case 1: {
                return (int)(ip >> 24) & 0xFF;
            }
            case 2: {
                return (int)(ip >> 16) & 0xFF;
            }
            case 3: {
                return (int)(ip >> 8) & 0xFF;
            }
            case 4: {
                return (int)ip & 0xFF;
            }
        }
        throw new IllegalArgumentException("Illegal position of ip Long: " + position);
    }

    public static boolean matches(String wildcard, String ipAddress) {
        String[] ipSegments;
        if (!PatternKit.isMatch(Pattern.IPV4_PATTERN, (CharSequence)ipAddress)) {
            return false;
        }
        String[] wildcardSegments = CharsBacker.splitToArray(wildcard, ".");
        if (wildcardSegments.length != (ipSegments = CharsBacker.splitToArray(ipAddress, ".")).length) {
            return false;
        }
        for (int i = 0; i < wildcardSegments.length; ++i) {
            if ("*".equals(wildcardSegments[i]) || wildcardSegments[i].equals(ipSegments[i])) continue;
            return false;
        }
        return true;
    }

    private static long matchAddress(Matcher matcher) {
        int addr = 0;
        addr |= Integer.parseInt(matcher.group(1));
        addr <<= 8;
        addr |= Integer.parseInt(matcher.group(2));
        addr <<= 8;
        addr |= Integer.parseInt(matcher.group(3));
        addr <<= 8;
        if ((addr |= Integer.parseInt(matcher.group(4))) < 0) {
            return 0xFFFFFFFFL & (long)addr;
        }
        return addr;
    }

    private static boolean isBetween(long userIp, long begin, long end) {
        return userIp >= begin && userIp <= end;
    }

    private static void assertMaskBitValid(int maskBit) {
        Assert.isTrue(IPv4.isMaskBitValid(maskBit), "Invalid maskBit\uff1a{}", maskBit);
    }
}

