/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.net.url;

import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;
import org.miaixz.bus.core.center.map.TableMap;
import org.miaixz.bus.core.codec.PercentCodec;
import org.miaixz.bus.core.convert.Convert;
import org.miaixz.bus.core.net.url.RFC3986;
import org.miaixz.bus.core.net.url.UrlDecoder;
import org.miaixz.bus.core.xyz.CollKit;
import org.miaixz.bus.core.xyz.IteratorKit;
import org.miaixz.bus.core.xyz.MapKit;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.core.xyz.StringKit;

public class UrlQuery {
    public static final PercentCodec ALL = PercentCodec.Builder.of(RFC3986.UNRESERVED).removeSafe('~').addSafe('*').setEncodeSpaceAsPlus(true).build();
    private final TableMap<CharSequence, CharSequence> query;
    private EncodeMode encodeMode;

    public UrlQuery(Map<? extends CharSequence, ?> queryMap, EncodeMode encodeMode) {
        if (MapKit.isNotEmpty(queryMap)) {
            this.query = new TableMap(queryMap.size());
            this.addAll(queryMap);
        } else {
            this.query = new TableMap(16);
        }
        this.encodeMode = ObjectKit.defaultIfNull(encodeMode, EncodeMode.NORMAL);
    }

    public static UrlQuery of(String queryStr, Charset charset) {
        return UrlQuery.of(queryStr, charset, true);
    }

    public static UrlQuery of(String queryStr, Charset charset, boolean autoRemovePath) {
        return UrlQuery.of(queryStr, charset, autoRemovePath, null);
    }

    public static UrlQuery of(String queryStr, Charset charset, boolean autoRemovePath, EncodeMode encodeMode) {
        return UrlQuery.of(encodeMode).parse(queryStr, charset, autoRemovePath);
    }

    public static UrlQuery of() {
        return UrlQuery.of(EncodeMode.NORMAL);
    }

    public static UrlQuery of(EncodeMode encodeMode) {
        return new UrlQuery(null, encodeMode);
    }

    public static UrlQuery of(Map<? extends CharSequence, ?> queryMap) {
        return UrlQuery.of(queryMap, null);
    }

    public static UrlQuery of(Map<? extends CharSequence, ?> queryMap, EncodeMode encodeMode) {
        return new UrlQuery(queryMap, encodeMode);
    }

    private static String toString(Object value) {
        String result = value instanceof Iterable ? CollKit.join((Iterable)value, ",") : (value instanceof Iterator ? IteratorKit.join((Iterator)value, ",") : Convert.toString(value));
        return result;
    }

    public UrlQuery setEncodeMode(EncodeMode encodeMode) {
        this.encodeMode = encodeMode;
        return this;
    }

    public UrlQuery add(CharSequence key, Object value) {
        this.query.put(key, UrlQuery.toString(value));
        return this;
    }

    public UrlQuery addAll(Map<? extends CharSequence, ?> queryMap) {
        if (MapKit.isNotEmpty(queryMap)) {
            queryMap.forEach(this::add);
        }
        return this;
    }

    public UrlQuery parse(String queryStr, Charset charset) {
        return this.parse(queryStr, charset, true);
    }

    public UrlQuery parse(String queryStr, Charset charset, boolean autoRemovePath) {
        int pathEndPos;
        if (StringKit.isBlank(queryStr)) {
            return this;
        }
        if (autoRemovePath && (pathEndPos = queryStr.indexOf(63)) > -1 && StringKit.isBlank(queryStr = StringKit.subSuf(queryStr, pathEndPos + 1))) {
            return this;
        }
        return this.doParse(queryStr, charset);
    }

    public Map<CharSequence, CharSequence> getQueryMap() {
        return MapKit.view(this.query);
    }

    public CharSequence get(CharSequence key) {
        if (MapKit.isEmpty(this.query)) {
            return null;
        }
        return this.query.get(key);
    }

    public String build(Charset charset) {
        return this.build(charset, null != charset);
    }

    public String build(Charset charset, boolean encodePercent) {
        switch (this.encodeMode.ordinal()) {
            case 1: {
                return this.build(ALL, ALL, charset, encodePercent);
            }
            case 2: {
                return this.build(RFC3986.QUERY_PARAM_NAME_STRICT, RFC3986.QUERY_PARAM_VALUE_STRICT, charset, encodePercent);
            }
        }
        return this.build(RFC3986.QUERY_PARAM_NAME, RFC3986.QUERY_PARAM_VALUE, charset, encodePercent);
    }

    public String build(PercentCodec keyCoder, PercentCodec valueCoder, Charset charset) {
        return this.build(keyCoder, valueCoder, charset, true);
    }

    public String build(PercentCodec keyCoder, PercentCodec valueCoder, Charset charset, boolean encodePercent) {
        char[] cArray;
        if (MapKit.isEmpty(this.query)) {
            return "";
        }
        if (encodePercent) {
            cArray = null;
        } else {
            char[] cArray2 = new char[1];
            cArray = cArray2;
            cArray2[0] = 37;
        }
        char[] safeChars = cArray;
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<CharSequence, CharSequence> entry : this.query) {
            CharSequence name = entry.getKey();
            if (null == name) continue;
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(keyCoder.encode(name, charset, safeChars));
            CharSequence value = entry.getValue();
            if (null == value) continue;
            sb.append("=").append(valueCoder.encode(value, charset, safeChars));
        }
        return sb.toString();
    }

    public String toString() {
        return this.build(null);
    }

    private UrlQuery doParse(String queryStr, Charset charset) {
        int i;
        int len = queryStr.length();
        String name = null;
        int pos = 0;
        block4: for (i = 0; i < len; ++i) {
            char c = queryStr.charAt(i);
            switch (c) {
                case '=': {
                    if (null != name) continue block4;
                    name = queryStr.substring(pos, i);
                    pos = i + 1;
                    continue block4;
                }
                case '&': {
                    this.addParam(name, queryStr.substring(pos, i), charset);
                    name = null;
                    if (i + 4 < len && "amp;".equals(queryStr.substring(i + 1, i + 5))) {
                        i += 4;
                    }
                    pos = i + 1;
                }
            }
        }
        this.addParam(name, queryStr.substring(pos, i), charset);
        return this;
    }

    private void addParam(String key, String value, Charset charset) {
        boolean isFormUrlEncoded;
        boolean bl = isFormUrlEncoded = EncodeMode.FORM_URL_ENCODED == this.encodeMode;
        if (null != key) {
            String actualKey = UrlDecoder.decode(key, charset, isFormUrlEncoded);
            this.query.put(actualKey, StringKit.emptyIfNull(UrlDecoder.decode(value, charset, isFormUrlEncoded)));
        } else if (null != value) {
            this.query.put(UrlDecoder.decode(value, charset, isFormUrlEncoded), null);
        }
    }

    public static enum EncodeMode {
        NORMAL,
        FORM_URL_ENCODED,
        STRICT;

    }
}

