/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.text.placeholder.template;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.UnaryOperator;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.text.placeholder.StringTemplate;
import org.miaixz.bus.core.text.placeholder.segment.LiteralSegment;
import org.miaixz.bus.core.text.placeholder.segment.SingleSegment;
import org.miaixz.bus.core.text.placeholder.segment.StringSegment;
import org.miaixz.bus.core.xyz.ArrayKit;

public class SingleStringTemplate
extends StringTemplate {
    public static final String DEFAULT_PLACEHOLDER = "{}";
    protected String placeholder;

    protected SingleStringTemplate(String template, int features, String placeholder, char escape, String defaultValue, UnaryOperator<String> defaultValueHandler) {
        super(template, escape, defaultValue, defaultValueHandler, features);
        Assert.notEmpty(placeholder);
        this.placeholder = placeholder;
        this.afterInit();
    }

    public static Builder builder(String template) {
        return new Builder(template);
    }

    @Override
    protected List<StringSegment> parseSegments(String template) {
        int placeholderLength = this.placeholder.length();
        int strPatternLength = template.length();
        int handledPosition = 0;
        boolean lastIsLiteralSegment = false;
        SingleSegment singlePlaceholderSegment = SingleSegment.newInstance(this.placeholder);
        ArrayList<StringSegment> segments = null;
        while (true) {
            int delimIndex;
            if ((delimIndex = template.indexOf(this.placeholder, handledPosition)) == -1) {
                if (handledPosition == 0) {
                    return Collections.singletonList(new LiteralSegment(template));
                }
                if (handledPosition < strPatternLength) {
                    this.addLiteralSegment(lastIsLiteralSegment, segments, template.substring(handledPosition));
                }
                return segments;
            }
            if (segments == null) {
                segments = new ArrayList<StringSegment>();
            }
            if (delimIndex > 0 && template.charAt(delimIndex - 1) == this.escape) {
                if (delimIndex > 1 && template.charAt(delimIndex - 2) == this.escape) {
                    this.addLiteralSegment(lastIsLiteralSegment, segments, template.substring(handledPosition, delimIndex - 1));
                    segments.add(singlePlaceholderSegment);
                    lastIsLiteralSegment = false;
                    handledPosition = delimIndex + placeholderLength;
                    continue;
                }
                this.addLiteralSegment(lastIsLiteralSegment, segments, template.substring(handledPosition, delimIndex - 1) + this.placeholder.charAt(0));
                lastIsLiteralSegment = true;
                handledPosition = delimIndex + 1;
                continue;
            }
            this.addLiteralSegment(lastIsLiteralSegment, segments, template.substring(handledPosition, delimIndex));
            segments.add(singlePlaceholderSegment);
            lastIsLiteralSegment = false;
            handledPosition = delimIndex + placeholderLength;
        }
    }

    public String format(Object ... args) {
        return this.formatArray(args);
    }

    public String formatArray(Object array) {
        return this.formatArray(ArrayKit.wrap(array));
    }

    public String formatArray(Object[] array) {
        if (array == null) {
            return this.getTemplate();
        }
        return this.format(Arrays.asList(array));
    }

    public String format(Iterable<?> iterable) {
        return super.formatSequence(iterable);
    }

    public String[] matchesToArray(String text) {
        return this.matches(text).toArray(new String[0]);
    }

    public List<String> matches(String text) {
        return super.matchesSequence(text);
    }

    public static class Builder
    extends StringTemplate.AbstractBuilder<Builder, SingleStringTemplate> {
        protected String placeholder;

        protected Builder(String template) {
            super(template);
        }

        public Builder placeholder(String placeholder) {
            this.placeholder = placeholder;
            return this;
        }

        @Override
        protected SingleStringTemplate buildInstance() {
            if (this.placeholder == null) {
                this.placeholder = SingleStringTemplate.DEFAULT_PLACEHOLDER;
            }
            return new SingleStringTemplate(this.template, this.features, this.placeholder, this.escape, this.defaultValue, this.defaultValueHandler);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

