/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.text.replacer;

import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.text.replacer.StringReplacer;
import org.miaixz.bus.core.xyz.StringKit;

public class SearchReplacer
extends StringReplacer {
    private static final long serialVersionUID = -1L;
    private final int fromIndex;
    private final CharSequence searchText;
    private final int searchTextLength;
    private final CharSequence replacement;
    private final boolean ignoreCase;

    public SearchReplacer(int fromIndex, CharSequence searchText, CharSequence replacement, boolean ignoreCase) {
        this.fromIndex = Math.max(fromIndex, 0);
        this.searchText = Assert.notEmpty(searchText, "'searchStr' must be not empty!", new Object[0]);
        this.searchTextLength = searchText.length();
        this.replacement = StringKit.emptyIfNull(replacement);
        this.ignoreCase = ignoreCase;
    }

    @Override
    public String apply(CharSequence text) {
        int consumed;
        if (StringKit.isEmpty(text)) {
            return StringKit.toString(text);
        }
        int strLength = text.length();
        if (strLength < this.searchTextLength) {
            return StringKit.toString(text);
        }
        int fromIndex = this.fromIndex;
        if (fromIndex > strLength) {
            return "";
        }
        StringBuilder result = new StringBuilder(strLength - this.searchTextLength + this.replacement.length());
        if (0 != fromIndex) {
            result.append(text.subSequence(0, fromIndex));
        }
        int pos = fromIndex;
        while ((consumed = this.replace(text, pos, result)) > 0) {
            pos += consumed;
        }
        if (pos < strLength) {
            result.append(text.subSequence(pos, strLength));
        }
        return result.toString();
    }

    @Override
    protected int replace(CharSequence text, int pos, StringBuilder out) {
        int index = StringKit.indexOf(text, this.searchText, pos, this.ignoreCase);
        if (index > -1) {
            out.append(text.subSequence(pos, index));
            out.append(this.replacement);
            return index - pos + this.searchTextLength;
        }
        return -1;
    }
}

