/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.tree;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.miaixz.bus.core.lang.Assert;

public abstract class HierarchyIterator<T>
implements Iterator<T> {
    protected final Function<T, Collection<T>> elementDiscoverer;
    protected final Predicate<T> filter;
    protected final Set<T> accessed = new HashSet<T>();
    protected final LinkedList<T> queue = new LinkedList();

    HierarchyIterator(T root, Function<T, Collection<T>> elementDiscoverer, Predicate<T> filter) {
        Assert.isTrue(filter.test(root), "root node cannot be filtered!", new Object[0]);
        this.queue.add(root);
        this.elementDiscoverer = Assert.notNull(elementDiscoverer);
        this.filter = Assert.notNull(filter);
    }

    public static <T> HierarchyIterator<T> breadthFirst(T root, Function<T, Collection<T>> nextDiscoverer, Predicate<T> filter) {
        return new BreadthFirst<T>(root, nextDiscoverer, filter);
    }

    public static <T> HierarchyIterator<T> breadthFirst(T root, Function<T, Collection<T>> nextDiscoverer) {
        return HierarchyIterator.breadthFirst(root, nextDiscoverer, t -> true);
    }

    public static <T> HierarchyIterator<T> depthFirst(T root, Function<T, Collection<T>> nextDiscoverer, Predicate<T> filter) {
        return new DepthFirst<T>(root, nextDiscoverer, filter);
    }

    public static <T> HierarchyIterator<T> depthFirst(T root, Function<T, Collection<T>> nextDiscoverer) {
        return HierarchyIterator.depthFirst(root, nextDiscoverer, t -> true);
    }

    @Override
    public boolean hasNext() {
        return !this.queue.isEmpty();
    }

    @Override
    public T next() {
        if (this.queue.isEmpty()) {
            throw new NoSuchElementException();
        }
        T curr = this.queue.removeFirst();
        this.accessed.add(curr);
        Collection nextElements = this.elementDiscoverer.apply(curr);
        if (Objects.nonNull(nextElements) && !nextElements.isEmpty()) {
            nextElements = nextElements.stream().filter(this.filter).collect(Collectors.toList());
            this.collectNextElementsToQueue(nextElements);
        }
        return curr;
    }

    protected abstract void collectNextElementsToQueue(Collection<T> var1);

    static class BreadthFirst<T>
    extends HierarchyIterator<T> {
        BreadthFirst(T root, Function<T, Collection<T>> nextDiscoverer, Predicate<T> filter) {
            super(root, nextDiscoverer, filter);
        }

        @Override
        protected void collectNextElementsToQueue(Collection<T> nextElements) {
            for (T nextElement : nextElements) {
                if (this.accessed.contains(nextElement)) continue;
                this.queue.addLast(nextElement);
                this.accessed.add(nextElement);
            }
        }
    }

    static class DepthFirst<T>
    extends HierarchyIterator<T> {
        DepthFirst(T root, Function<T, Collection<T>> nextDiscoverer, Predicate<T> filter) {
            super(root, nextDiscoverer, filter);
        }

        @Override
        protected void collectNextElementsToQueue(Collection<T> nextElements) {
            int idx = 0;
            for (T nextElement : nextElements) {
                if (this.accessed.contains(nextElement)) continue;
                this.queue.add(idx++, nextElement);
                this.accessed.add(nextElement);
            }
        }
    }
}

