/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.xyz;

import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.miaixz.bus.core.annotation.resolve.AnnotationMappingProxy;
import org.miaixz.bus.core.annotation.resolve.AnnotationProxy;
import org.miaixz.bus.core.annotation.resolve.elements.CombinationAnnotatedElement;
import org.miaixz.bus.core.center.function.FunctionX;
import org.miaixz.bus.core.center.function.LambdaInfo;
import org.miaixz.bus.core.center.map.reference.WeakConcurrentMap;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.text.CharsBacker;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.ClassKit;
import org.miaixz.bus.core.xyz.FieldKit;
import org.miaixz.bus.core.xyz.LambdaKit;
import org.miaixz.bus.core.xyz.MethodKit;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.core.xyz.StringKit;

public class AnnoKit {
    private static final String JDK_MEMBER_ATTRIBUTE = "memberValues";
    private static final String SPRING_MEMBER_ATTRIBUTE = "valueCache";
    private static final String BUS_MEMBER_ATTRIBUTE = "valueCache";
    private static final String SPRING_INVOCATION_HANDLER = "SynthesizedMergedAnnotationInvocationHandler";
    private static final Map<AnnotatedElement, Annotation[]> DECLARED_ANNOTATIONS_CACHE = new WeakConcurrentMap<AnnotatedElement, Annotation[]>();

    public static Annotation[] getDeclaredAnnotations(AnnotatedElement element) {
        return DECLARED_ANNOTATIONS_CACHE.computeIfAbsent(element, AnnotatedElement::getDeclaredAnnotations);
    }

    public static CombinationAnnotatedElement toCombination(AnnotatedElement annotationEle) {
        if (annotationEle instanceof CombinationAnnotatedElement) {
            return (CombinationAnnotatedElement)annotationEle;
        }
        return new CombinationAnnotatedElement(annotationEle);
    }

    public static Annotation[] getAnnotations(AnnotatedElement annotationEle, boolean isToCombination) {
        return AnnoKit.getAnnotations(annotationEle, isToCombination, (Predicate<Annotation>)null);
    }

    public static <T> T[] getCombinationAnnotations(AnnotatedElement annotationEle, Class<T> annotationType) {
        return AnnoKit.getAnnotations(annotationEle, true, annotationType);
    }

    public static <T> T[] getAnnotations(AnnotatedElement annotationEle, boolean isToCombination, Class<T> annotationType) {
        Annotation[] annotations = AnnoKit.getAnnotations(annotationEle, isToCombination, (Annotation annotation) -> null == annotationType || annotationType.isAssignableFrom(annotation.getClass()));
        T[] result = ArrayKit.newArray(annotationType, annotations.length);
        for (int i = 0; i < annotations.length; ++i) {
            result[i] = annotations[i];
        }
        return result;
    }

    public static Annotation[] getAnnotations(AnnotatedElement annotationEle, boolean isToCombination, Predicate<Annotation> predicate) {
        if (null == annotationEle) {
            return null;
        }
        if (isToCombination) {
            if (null == predicate) {
                return AnnoKit.toCombination(annotationEle).getAnnotations();
            }
            return CombinationAnnotatedElement.of(annotationEle, predicate).getAnnotations();
        }
        Annotation[] result = annotationEle.getAnnotations();
        if (null == predicate) {
            return result;
        }
        return ArrayKit.filter(result, predicate);
    }

    public static <A extends Annotation> A getAnnotation(AnnotatedElement annotationEle, Class<A> annotationType) {
        return null == annotationEle ? null : (A)AnnoKit.toCombination(annotationEle).getAnnotation(annotationType);
    }

    public static boolean hasAnnotation(AnnotatedElement annotationEle, Class<? extends Annotation> annotationType) {
        return null != AnnoKit.getAnnotation(annotationEle, annotationType);
    }

    public static <T> T getAnnotationValue(AnnotatedElement annotationEle, Class<? extends Annotation> annotationType) throws InternalException {
        return AnnoKit.getAnnotationValue(annotationEle, annotationType, "value");
    }

    public static <A extends Annotation, R> R getAnnotationValue(AnnotatedElement annotationEle, FunctionX<A, R> propertyName) {
        if (propertyName == null) {
            return null;
        }
        LambdaInfo lambda = LambdaKit.resolve(propertyName);
        String instantiatedMethodType = lambda.getLambda().getInstantiatedMethodType();
        Class annotationClass = ClassKit.loadClass(StringKit.sub(instantiatedMethodType, 2, StringKit.indexOf(instantiatedMethodType, ';')));
        return (R)AnnoKit.getAnnotationValue(annotationEle, annotationClass, lambda.getLambda().getImplMethodName());
    }

    public static <T> T getAnnotationValue(AnnotatedElement annotationEle, Class<? extends Annotation> annotationType, String propertyName) throws InternalException {
        Annotation annotation = AnnoKit.getAnnotation(annotationEle, annotationType);
        if (null == annotation) {
            return null;
        }
        Method method = MethodKit.getMethodOfObject(annotation, propertyName, new Object[0]);
        if (null == method) {
            return null;
        }
        return MethodKit.invoke((Object)annotation, method, new Object[0]);
    }

    public static Map<String, Object> getAnnotationValueMap(AnnotatedElement annotationEle, Class<? extends Annotation> annotationType) throws InternalException {
        Annotation annotation = AnnoKit.getAnnotation(annotationEle, annotationType);
        if (null == annotation) {
            return null;
        }
        Method[] methods = MethodKit.getMethods(annotationType, t -> {
            if (ArrayKit.isEmpty(t.getParameterTypes())) {
                String name = t.getName();
                return !"hashCode".equals(name) && !"toString".equals(name) && !"annotationType".equals(name);
            }
            return false;
        });
        HashMap<String, Object> result = new HashMap<String, Object>(methods.length, 1.0f);
        for (Method method : methods) {
            result.put(method.getName(), MethodKit.invoke((Object)annotation, method, new Object[0]));
        }
        return result;
    }

    public static RetentionPolicy getRetentionPolicy(Class<? extends Annotation> annotationType) {
        Retention retention = annotationType.getAnnotation(Retention.class);
        if (null == retention) {
            return RetentionPolicy.CLASS;
        }
        return retention.value();
    }

    public static ElementType[] getTargetType(Class<? extends Annotation> annotationType) {
        Target target = annotationType.getAnnotation(Target.class);
        if (null == target) {
            return ElementType.values();
        }
        return target.value();
    }

    public static boolean isDocumented(Class<? extends Annotation> annotationType) {
        return annotationType.isAnnotationPresent(Documented.class);
    }

    public static boolean isInherited(Class<? extends Annotation> annotationType) {
        return annotationType.isAnnotationPresent(Inherited.class);
    }

    public static void setValue(Annotation annotation, String annotationField, Object value) {
        InvocationHandler invocationHandler = Proxy.getInvocationHandler(annotation);
        String memberAttributeName = JDK_MEMBER_ATTRIBUTE;
        if (CharsBacker.contains((CharSequence)invocationHandler.getClass().getName(), SPRING_INVOCATION_HANDLER)) {
            memberAttributeName = "valueCache";
        } else if (invocationHandler instanceof AnnotationMappingProxy) {
            memberAttributeName = "valueCache";
        }
        Map memberValues = (Map)FieldKit.getFieldValue((Object)invocationHandler, memberAttributeName);
        memberValues.put(annotationField, value);
    }

    public static <T extends Annotation> T getAnnotationAlias(AnnotatedElement annotationEle, Class<T> annotationType) {
        T annotation = AnnoKit.getAnnotation(annotationEle, annotationType);
        if (null == annotation) {
            return null;
        }
        return (T)((Annotation)Proxy.newProxyInstance(annotationType.getClassLoader(), new Class[]{annotationType}, new AnnotationProxy<T>(annotation)));
    }

    public static Method[] getAnnotationAttributes(Class<? extends Annotation> annotationType) {
        return (Method[])Stream.of(MethodKit.getDeclaredMethods(annotationType)).filter(AnnoKit::isAnnotationAttribute).toArray(Method[]::new);
    }

    public static boolean isAnnotationAttribute(Method attribute) {
        return !MethodKit.isEqualsMethod(attribute) && !MethodKit.isHashCodeMethod(attribute) && !MethodKit.isToStringMethod(attribute) && ArrayKit.isEmpty(attribute.getParameterTypes()) && ObjectKit.notEquals(attribute.getReturnType(), Void.class) && !Modifier.isStatic(attribute.getModifiers()) && Modifier.isPublic(attribute.getModifiers()) && !attribute.isBridge() && !attribute.isSynthetic();
    }

    public static void clearCaches() {
        DECLARED_ANNOTATIONS_CACHE.clear();
    }
}

