/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.xyz;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.miaixz.bus.core.annotation.Alias;
import org.miaixz.bus.core.center.map.reference.WeakConcurrentMap;
import org.miaixz.bus.core.convert.Convert;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.lang.reflect.field.FieldReflect;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.ClassKit;
import org.miaixz.bus.core.xyz.MapKit;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.core.xyz.ReflectKit;
import org.miaixz.bus.core.xyz.StringKit;

public class FieldKit {
    private static final WeakConcurrentMap<Class<?>, FieldReflect> FIELDS_CACHE = new WeakConcurrentMap();

    static synchronized void clearCache() {
        FIELDS_CACHE.clear();
    }

    public static boolean isOuterClassField(Field field) {
        return "this$0".equals(field.getName());
    }

    public static boolean hasField(Class<?> beanClass, String name) throws SecurityException {
        return null != FieldKit.getField(beanClass, name);
    }

    public static String getFieldName(Field field) {
        return FieldKit.getFieldName(field, true);
    }

    public static String getFieldName(Field field, boolean useAlias) {
        Alias alias;
        if (null == field) {
            return null;
        }
        if (useAlias && null != (alias = field.getAnnotation(Alias.class))) {
            return alias.value();
        }
        return field.getName();
    }

    public static Field getDeclearField(Class<?> beanClass, String name) {
        Field[] fields = FieldKit.getDeclaredFields(beanClass, field -> StringKit.equals(name, field.getName()));
        return ArrayKit.isEmpty(fields) ? null : fields[0];
    }

    public static Field getField(Class<?> beanClass, String name) throws SecurityException {
        Field[] fields = FieldKit.getFields(beanClass, field -> StringKit.equals(name, field.getName()));
        return ArrayKit.isEmpty(fields) ? null : fields[0];
    }

    public static Map<String, Field> getFieldMap(Class<?> beanClass) {
        Field[] fields = FieldKit.getFields(beanClass);
        HashMap<String, Field> map = MapKit.newHashMap(fields.length, true);
        for (Field field : fields) {
            map.putIfAbsent(field.getName(), field);
        }
        return map;
    }

    public static Field[] getFields(Class<?> beanClass) throws SecurityException {
        return FieldKit.getFields(beanClass, null);
    }

    public static Field[] getFields(Class<?> beanClass, Predicate<Field> filter) throws SecurityException {
        Assert.notNull(beanClass);
        return FIELDS_CACHE.computeIfAbsent(beanClass, FieldReflect::of).getAllFields(filter);
    }

    public static Field[] getDeclaredFields(Class<?> beanClass, Predicate<Field> filter) throws SecurityException {
        Assert.notNull(beanClass);
        return FIELDS_CACHE.computeIfAbsent(beanClass, FieldReflect::of).getDeclaredFields(filter);
    }

    public static Field[] getFieldsDirectly(Class<?> beanClass, boolean withSuperClassFields) throws SecurityException {
        return FieldReflect.of(beanClass).getFieldsDirectly(withSuperClassFields);
    }

    public static Object getFieldValue(Object obj, String fieldName) throws InternalException {
        if (null == obj || StringKit.isBlank(fieldName)) {
            return null;
        }
        return FieldKit.getFieldValue(obj, FieldKit.getField(obj instanceof Class ? (Class<?>)obj : obj.getClass(), fieldName));
    }

    public static Object getStaticFieldValue(Field field) throws InternalException {
        return FieldKit.getFieldValue(null, field);
    }

    public static Object getFieldValue(Object obj, Field field) throws InternalException {
        Object result;
        if (null == field) {
            return null;
        }
        if (obj instanceof Class) {
            obj = null;
        }
        ReflectKit.setAccessible(field);
        try {
            result = field.get(obj);
        }
        catch (IllegalAccessException e) {
            throw new InternalException(e, "IllegalAccess for {}.{}", field.getDeclaringClass(), field.getName());
        }
        return result;
    }

    public static Object[] getFieldsValue(Object obj) {
        return FieldKit.getFieldsValue(obj, null);
    }

    public static Object[] getFieldsValue(Object obj, Predicate<Field> filter) {
        Field[] fields;
        if (null != obj && null != (fields = FieldKit.getFields(obj instanceof Class ? (Class<?>)obj : obj.getClass(), filter))) {
            return ArrayKit.map(fields, Object.class, field -> FieldKit.getFieldValue(obj, field));
        }
        return null;
    }

    public static Object getFieldsAndValue(Object obj) {
        Field[] fields;
        if (null != obj && null != (fields = FieldKit.getFields(obj instanceof Class ? (Class<?>)obj : obj.getClass()))) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (Field field : fields) {
                Object object = FieldKit.getFieldValue(obj, field);
                if (!ObjectKit.isNotEmpty(object) || FieldKit.isSerialVersionUID(field)) continue;
                map.put(field.getName(), FieldKit.getFieldValue(obj, field));
            }
            return map;
        }
        return null;
    }

    public static Object getFieldsAndValue(Object obj, Predicate<Field> filter) {
        Field[] fields;
        if (null != obj && null != (fields = FieldKit.getFields(obj instanceof Class ? (Class<?>)obj : obj.getClass(), filter))) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (Field field : fields) {
                Object object = FieldKit.getFieldValue(obj, field);
                if (!ObjectKit.isNotEmpty(object) || FieldKit.isSerialVersionUID(field)) continue;
                map.put(field.getName(), FieldKit.getFieldValue(obj, field));
            }
            return map;
        }
        return null;
    }

    public static void setFieldValue(Object obj, String fieldName, Object value) throws InternalException {
        Assert.notNull(obj, "Object must be not null !", new Object[0]);
        Assert.notBlank(fieldName);
        Field field = FieldKit.getField(obj instanceof Class ? (Class<?>)obj : obj.getClass(), fieldName);
        Assert.notNull(field, "Field [{}] is not exist in [{}]", fieldName, obj.getClass().getName());
        FieldKit.setFieldValue(obj, field, value);
    }

    public static void setStaticFieldValue(Field field, Object value) throws InternalException {
        FieldKit.setFieldValue(null, field, value);
    }

    public static void setFieldValue(Object obj, Field field, Object value) throws InternalException {
        Assert.notNull(field, "Field in [{}] not exist !", obj);
        Class<?> fieldType = field.getType();
        if (null != value) {
            Object targetValue;
            if (!fieldType.isAssignableFrom(value.getClass()) && null != (targetValue = Convert.convert(fieldType, value))) {
                value = targetValue;
            }
        } else {
            value = ClassKit.getDefaultValue(fieldType);
        }
        FieldKit.setFieldValueExact(obj, field, value);
    }

    public static void setFieldValueExact(Object obj, Field field, Object value) throws InternalException {
        ReflectKit.setAccessible(field);
        try {
            field.set(obj instanceof Class ? null : obj, value);
        }
        catch (IllegalAccessException e) {
            throw new InternalException(e, "IllegalAccess for [{}.{}]", null == obj ? field.getDeclaringClass() : obj, field.getName());
        }
    }

    public static boolean isSerialVersionUID(Field field) {
        return "serialVersionUID".equals(field.getName()) && (Long.class.equals(field.getType()) || Long.TYPE.equals(field.getType())) && field.getModifiers() == 26;
    }
}

