/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.xyz;

import java.util.function.Predicate;
import java.util.stream.Stream;
import org.miaixz.bus.core.xyz.StreamKit;

public class PredicateKit {
    public static <T> Predicate<T> alwaysTrue() {
        return method -> true;
    }

    static <T> Predicate<T> coerce(Predicate<? super T> predicate) {
        return predicate;
    }

    public static <T> Predicate<T> negate(Predicate<T> predicate) {
        return predicate.negate();
    }

    public static <T> Predicate<T> and(Iterable<Predicate<T>> components) {
        return StreamKit.of(components, false).reduce(Predicate::and).orElseGet(() -> o -> true);
    }

    @SafeVarargs
    public static <T> Predicate<T> and(Predicate<T> ... components) {
        return StreamKit.of(components).reduce(Predicate::and).orElseGet(() -> o -> true);
    }

    public static <T> Predicate<T> or(Iterable<Predicate<T>> components) {
        return StreamKit.of(components, false).reduce(Predicate::or).orElseGet(() -> o -> false);
    }

    @SafeVarargs
    public static <T> Predicate<T> or(Predicate<T> ... components) {
        return StreamKit.of(components).reduce(Predicate::or).orElseGet(() -> o -> false);
    }

    @SafeVarargs
    public static <T> Predicate<T> none(Predicate<T> ... components) {
        return t -> Stream.of(components).noneMatch(matcher -> matcher.test(t));
    }
}

