/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.xyz;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import org.miaixz.bus.core.center.map.TripleTable;
import org.miaixz.bus.core.center.map.reference.WeakConcurrentMap;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.lang.reflect.creator.DefaultObjectCreator;
import org.miaixz.bus.core.lang.reflect.creator.PossibleObjectCreator;
import org.miaixz.bus.core.text.StringTrimer;
import org.miaixz.bus.core.xyz.ClassKit;
import org.miaixz.bus.core.xyz.StringKit;

public class ReflectKit {
    public static final char JVM_VOID = 'V';
    public static final char JVM_BOOLEAN = 'Z';
    public static final char JVM_BYTE = 'B';
    public static final char JVM_CHAR = 'C';
    public static final char JVM_DOUBLE = 'D';
    public static final char JVM_FLOAT = 'F';
    public static final char JVM_INT = 'I';
    public static final char JVM_LONG = 'J';
    public static final char JVM_SHORT = 'S';
    private static final TripleTable<Class<?>, Character, String> PRIMITIVE_TABLE = new TripleTable(9);
    private static final WeakConcurrentMap<Class<?>, Constructor<?>[]> CONSTRUCTORS_CACHE = new WeakConcurrentMap();

    public static Class<?> descToClass(String desc) throws InternalException {
        return ReflectKit.descToClass(desc, true, null);
    }

    public static Class<?> descToClass(String desc, boolean isInitialized, ClassLoader cl) throws InternalException {
        Assert.notNull(desc, "Name must not be null", new Object[0]);
        char firstChar = desc.charAt(0);
        Class<?> clazz = PRIMITIVE_TABLE.getLeftByMiddle(Character.valueOf(firstChar));
        if (null != clazz) {
            return clazz;
        }
        desc = StringKit.trim(desc, StringTrimer.TrimMode.SUFFIX, c -> '/' == c.charValue() || '.' == c.charValue());
        if ('L' == firstChar) {
            desc = desc.substring(1, desc.length() - 1);
        }
        return ClassKit.forName(desc, isInitialized, cl);
    }

    public static String getDesc(Class<?> c) {
        StringBuilder ret = new StringBuilder();
        while (c.isArray()) {
            ret.append('[');
            c = c.getComponentType();
        }
        if (c.isPrimitive()) {
            Character desc = PRIMITIVE_TABLE.getMiddleByLeft(c);
            if (null != desc) {
                ret.append(desc.charValue());
            }
        } else {
            ret.append('L');
            ret.append(c.getName().replace('.', '/'));
            ret.append(';');
        }
        return ret.toString();
    }

    public static String getDesc(Executable methodOrConstructor, boolean appendName) {
        Class<?>[] parameterTypes;
        StringBuilder ret = new StringBuilder();
        if (appendName && methodOrConstructor instanceof Method) {
            ret.append(methodOrConstructor.getName());
        }
        ret.append('(');
        for (Class<?> parameterType : parameterTypes = methodOrConstructor.getParameterTypes()) {
            ret.append(ReflectKit.getDesc(parameterType));
        }
        ret.append(')');
        if (methodOrConstructor instanceof Method) {
            ret.append(ReflectKit.getDesc(((Method)methodOrConstructor).getReturnType()));
        } else {
            ret.append('V');
        }
        return ret.toString();
    }

    public static String getName(Class<?> c) {
        if (c.isArray()) {
            StringBuilder sb = new StringBuilder();
            do {
                sb.append("[]");
            } while ((c = c.getComponentType()).isArray());
            return c.getName() + String.valueOf(sb);
        }
        return c.getName();
    }

    public static String getName(Executable executable) {
        StringBuilder ret = new StringBuilder("(");
        if (executable instanceof Method) {
            ret.append(ReflectKit.getName(((Method)executable).getReturnType())).append(' ');
        }
        Class<?>[] parameterTypes = executable.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (i > 0) {
                ret.append(',');
            }
            ret.append(ReflectKit.getName(parameterTypes[i]));
        }
        ret.append(')');
        return ret.toString();
    }

    public static Class<?> nameToClass(String name, boolean isInitialized, ClassLoader cl) {
        Assert.notNull(name, "Name must not be null", new Object[0]);
        name = StringKit.trim(name, StringTrimer.TrimMode.SUFFIX, c -> '/' == c.charValue() || '.' == c.charValue());
        int c2 = 0;
        int index = name.indexOf(91);
        if (index > 0) {
            c2 = (name.length() - index) / 2;
            name = name.substring(0, index);
        }
        if (c2 > 0) {
            StringBuilder sb = new StringBuilder();
            while (c2-- > 0) {
                sb.append('[');
            }
            Class<?> clazz = PRIMITIVE_TABLE.getLeftByRight(name);
            if (null != clazz) {
                sb.append(PRIMITIVE_TABLE.getMiddleByLeft(clazz).charValue());
            } else {
                sb.append('L').append(name).append(';');
            }
            name = sb.toString();
        } else {
            Class<?> clazz = PRIMITIVE_TABLE.getLeftByRight(name);
            if (null != clazz) {
                return clazz;
            }
        }
        return ClassKit.forName(name, isInitialized, cl);
    }

    public static String nameToDesc(String name) {
        StringBuilder sb = new StringBuilder();
        int c = 0;
        int index = name.indexOf(91);
        if (index > 0) {
            c = (name.length() - index) / 2;
            name = name.substring(0, index);
        }
        while (c-- > 0) {
            sb.append('[');
        }
        Class<?> clazz = PRIMITIVE_TABLE.getLeftByRight(name);
        if (null != clazz) {
            sb.append(PRIMITIVE_TABLE.getMiddleByLeft(clazz).charValue());
        } else {
            sb.append('L').append(name.replace('.', '/')).append(';');
        }
        return sb.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String descToName(String desc) {
        StringBuilder sb = new StringBuilder();
        int c = desc.lastIndexOf(91) + 1;
        if (desc.length() == c + 1) {
            char descChar = desc.charAt(c);
            Class<?> clazz = PRIMITIVE_TABLE.getLeftByMiddle(Character.valueOf(descChar));
            if (null == clazz) throw new InternalException("Unsupported primitive desc: {}", desc);
            sb.append(PRIMITIVE_TABLE.getRightByLeft(clazz));
        } else {
            sb.append(desc.substring(c + 1, desc.length() - 1).replace('/', '.'));
        }
        while (c-- > 0) {
            sb.append("[]");
        }
        return sb.toString();
    }

    public static String getCodeBase(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        ProtectionDomain domain = clazz.getProtectionDomain();
        if (domain == null) {
            return null;
        }
        CodeSource source = domain.getCodeSource();
        if (source == null) {
            return null;
        }
        URL location = source.getLocation();
        if (location == null) {
            return null;
        }
        return location.getFile();
    }

    public static <T extends AccessibleObject> T setAccessibleQuietly(T accessibleObject) {
        try {
            ReflectKit.setAccessible(accessibleObject);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return accessibleObject;
    }

    public static <T extends AccessibleObject> T setAccessible(T accessibleObject) throws SecurityException {
        if (null != accessibleObject && !accessibleObject.isAccessible()) {
            accessibleObject.setAccessible(true);
        }
        return accessibleObject;
    }

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> ... parameterTypes) {
        Constructor<T>[] constructors;
        if (null == clazz) {
            return null;
        }
        for (Constructor<T> constructor : constructors = ReflectKit.getConstructors(clazz)) {
            Class<?>[] pts = constructor.getParameterTypes();
            if (!ClassKit.isAllAssignableFrom(pts, parameterTypes)) continue;
            ReflectKit.setAccessible(constructor);
            return constructor;
        }
        return null;
    }

    public static <T> Constructor<T>[] getConstructors(Class<T> beanClass) throws SecurityException {
        Assert.notNull(beanClass);
        return CONSTRUCTORS_CACHE.computeIfAbsent(beanClass, key -> ReflectKit.getConstructorsDirectly(beanClass));
    }

    public static Constructor<?>[] getConstructorsDirectly(Class<?> beanClass) throws SecurityException {
        return beanClass.getDeclaredConstructors();
    }

    public static <T> T newInstance(String clazz) throws InternalException {
        return DefaultObjectCreator.of(clazz).create();
    }

    public static <T> T newInstance(Class<T> clazz, Object ... params) throws InternalException {
        return DefaultObjectCreator.of(clazz, params).create();
    }

    public static <T> T newInstanceIfPossible(Class<T> type) {
        return PossibleObjectCreator.of(type).create();
    }

    static {
        PRIMITIVE_TABLE.put(Void.TYPE, Character.valueOf('V'), "void");
        PRIMITIVE_TABLE.put(Boolean.TYPE, Character.valueOf('Z'), "boolean");
        PRIMITIVE_TABLE.put(Byte.TYPE, Character.valueOf('B'), "byte");
        PRIMITIVE_TABLE.put(Character.TYPE, Character.valueOf('C'), "char");
        PRIMITIVE_TABLE.put(Double.TYPE, Character.valueOf('D'), "double");
        PRIMITIVE_TABLE.put(Float.TYPE, Character.valueOf('F'), "float");
        PRIMITIVE_TABLE.put(Integer.TYPE, Character.valueOf('I'), "int");
        PRIMITIVE_TABLE.put(Long.TYPE, Character.valueOf('J'), "long");
        PRIMITIVE_TABLE.put(Short.TYPE, Character.valueOf('S'), "short");
    }
}

