/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.xyz;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.Watchable;
import org.miaixz.bus.core.io.file.PathResolve;
import org.miaixz.bus.core.io.watch.WatchKind;
import org.miaixz.bus.core.io.watch.WatchMonitor;
import org.miaixz.bus.core.io.watch.Watcher;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.UrlKit;

public class WatchKit {
    public static WatchMonitor of(URL url, WatchEvent.Kind<?> ... events) {
        return WatchKit.of(url, 0, events);
    }

    public static WatchMonitor of(URL url, int maxDepth, WatchEvent.Kind<?> ... events) {
        return WatchKit.of(UrlKit.toURI(url), maxDepth, events);
    }

    public static WatchMonitor of(URI uri, WatchEvent.Kind<?> ... events) {
        return WatchKit.of(uri, 0, events);
    }

    public static WatchMonitor of(URI uri, int maxDepth, WatchEvent.Kind<?> ... events) {
        return WatchKit.of(Paths.get(uri), maxDepth, events);
    }

    public static WatchMonitor of(File file, WatchEvent.Kind<?> ... events) {
        return WatchKit.of(file, 0, events);
    }

    public static WatchMonitor of(File file, int maxDepth, WatchEvent.Kind<?> ... events) {
        return WatchKit.of(file.toPath(), maxDepth, events);
    }

    public static WatchMonitor of(String path, WatchEvent.Kind<?> ... events) {
        return WatchKit.of(path, 0, events);
    }

    public static WatchMonitor of(String path, int maxDepth, WatchEvent.Kind<?> ... events) {
        return WatchKit.of(Paths.get(path, new String[0]), maxDepth, events);
    }

    public static WatchMonitor of(Path path, WatchEvent.Kind<?> ... events) {
        return WatchKit.of(path, 0, events);
    }

    public static WatchMonitor of(Path path, int maxDepth, WatchEvent.Kind<?> ... events) {
        return new WatchMonitor(path, maxDepth, events);
    }

    public static WatchMonitor ofAll(URL url, Watcher watcher) {
        return WatchKit.ofAll(url, 0, watcher);
    }

    public static WatchMonitor ofAll(URL url, int maxDepth, Watcher watcher) {
        return WatchKit.ofAll(UrlKit.toURI(url), maxDepth, watcher);
    }

    public static WatchMonitor ofAll(URI uri, Watcher watcher) {
        return WatchKit.ofAll(uri, 0, watcher);
    }

    public static WatchMonitor ofAll(URI uri, int maxDepth, Watcher watcher) {
        return WatchKit.ofAll(Paths.get(uri), maxDepth, watcher);
    }

    public static WatchMonitor ofAll(File file, Watcher watcher) {
        return WatchKit.ofAll(file, 0, watcher);
    }

    public static WatchMonitor ofAll(File file, int maxDepth, Watcher watcher) {
        return WatchKit.ofAll(file.toPath(), maxDepth, watcher);
    }

    public static WatchMonitor ofAll(String path, Watcher watcher) {
        return WatchKit.ofAll(path, 0, watcher);
    }

    public static WatchMonitor ofAll(String path, int maxDepth, Watcher watcher) {
        return WatchKit.ofAll(Paths.get(path, new String[0]), maxDepth, watcher);
    }

    public static WatchMonitor ofAll(Path path, Watcher watcher) {
        return WatchKit.ofAll(path, 0, watcher);
    }

    public static WatchMonitor ofAll(Path path, int maxDepth, Watcher watcher) {
        return WatchKit.of(path, maxDepth, WatchKind.ALL).setWatcher(watcher);
    }

    public static WatchMonitor ofModify(URL url, Watcher watcher) {
        return WatchKit.ofModify(url, 0, watcher);
    }

    public static WatchMonitor ofModify(URL url, int maxDepth, Watcher watcher) {
        return WatchKit.ofModify(UrlKit.toURI(url), maxDepth, watcher);
    }

    public static WatchMonitor ofModify(URI uri, Watcher watcher) {
        return WatchKit.ofModify(uri, 0, watcher);
    }

    public static WatchMonitor ofModify(URI uri, int maxDepth, Watcher watcher) {
        return WatchKit.ofModify(Paths.get(uri), maxDepth, watcher);
    }

    public static WatchMonitor ofModify(File file, Watcher watcher) {
        return WatchKit.ofModify(file, 0, watcher);
    }

    public static WatchMonitor ofModify(File file, int maxDepth, Watcher watcher) {
        return WatchKit.ofModify(file.toPath(), maxDepth, watcher);
    }

    public static WatchMonitor ofModify(String path, Watcher watcher) {
        return WatchKit.ofModify(path, 0, watcher);
    }

    public static WatchMonitor ofModify(String path, int maxDepth, Watcher watcher) {
        return WatchKit.ofModify(Paths.get(path, new String[0]), maxDepth, watcher);
    }

    public static WatchMonitor ofModify(Path path, Watcher watcher) {
        return WatchKit.ofModify(path, 0, watcher);
    }

    public static WatchMonitor ofModify(Path path, int maxDepth, Watcher watcher) {
        WatchMonitor watchMonitor = WatchKit.of(path, maxDepth, WatchKind.MODIFY.getValue());
        watchMonitor.setWatcher(watcher);
        return watchMonitor;
    }

    public static WatchKey register(Watchable watchable, WatchService watcher, WatchEvent.Kind<?> ... events) {
        try {
            return watchable.register(watcher, events);
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    public static Path resolvePath(WatchEvent<?> event, WatchKey key) {
        Assert.notNull(event, "WatchEvent must be not null!", new Object[0]);
        Assert.notNull(event, "WatchKey must be not null!", new Object[0]);
        return PathResolve.of((Path)key.watchable(), (Path)event.context());
    }
}

