/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.annotation.resolve;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.stream.Stream;
import org.miaixz.bus.core.annotation.resolve.AnnotationMapping;
import org.miaixz.bus.core.text.CharsBacker;
import org.miaixz.bus.core.xyz.AnnoKit;
import org.miaixz.bus.core.xyz.ClassKit;
import org.miaixz.bus.core.xyz.MethodKit;

public class GenericAnnotationMapping
implements AnnotationMapping<Annotation> {
    private final Annotation annotation;
    private final boolean isRoot;
    private final Method[] attributes;

    public GenericAnnotationMapping(Annotation annotation, boolean isRoot) {
        this.annotation = Objects.requireNonNull(annotation);
        this.isRoot = isRoot;
        this.attributes = AnnoKit.getAnnotationAttributes(annotation.annotationType());
    }

    public static GenericAnnotationMapping create(Annotation annotation, boolean isRoot) {
        return new GenericAnnotationMapping(annotation, isRoot);
    }

    @Override
    public boolean isRoot() {
        return this.isRoot;
    }

    @Override
    public Annotation getAnnotation() {
        return this.annotation;
    }

    @Override
    public Annotation getResolvedAnnotation() {
        return this.getAnnotation();
    }

    @Override
    public boolean isResolved() {
        return false;
    }

    @Override
    public Method[] getAttributes() {
        return this.attributes;
    }

    @Override
    public <R> R getAttributeValue(String attributeName, Class<R> attributeType) {
        return Stream.of(this.attributes).filter(attribute -> CharsBacker.equals(attribute.getName(), attributeName)).filter(attribute -> ClassKit.isAssignable(attributeType, attribute.getReturnType())).findFirst().map(method -> MethodKit.invoke((Object)this.annotation, method, new Object[0])).map(attributeType::cast).orElse(null);
    }

    @Override
    public <R> R getResolvedAttributeValue(String attributeName, Class<R> attributeType) {
        return this.getAttributeValue(attributeName, attributeType);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericAnnotationMapping that = (GenericAnnotationMapping)o;
        return this.isRoot == that.isRoot && this.annotation.equals(that.annotation);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.annotation, this.isRoot);
    }
}

