/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.basics.entity;

public class Message {
    public String errcode;
    public String errmsg;
    public Object data;

    protected Message(MessageBuilder<?, ?> b) {
        this.errcode = b.errcode;
        this.errmsg = b.errmsg;
        this.data = b.data;
    }

    public static MessageBuilder<?, ?> builder() {
        return new MessageBuilderImpl();
    }

    public String getErrcode() {
        return this.errcode;
    }

    public String getErrmsg() {
        return this.errmsg;
    }

    public Object getData() {
        return this.data;
    }

    public void setErrcode(String errcode) {
        this.errcode = errcode;
    }

    public void setErrmsg(String errmsg) {
        this.errmsg = errmsg;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public Message() {
    }

    public Message(String errcode, String errmsg, Object data) {
        this.errcode = errcode;
        this.errmsg = errmsg;
        this.data = data;
    }

    public static abstract class MessageBuilder<C extends Message, B extends MessageBuilder<C, B>> {
        private String errcode;
        private String errmsg;
        private Object data;

        public B errcode(String errcode) {
            this.errcode = errcode;
            return this.self();
        }

        public B errmsg(String errmsg) {
            this.errmsg = errmsg;
            return this.self();
        }

        public B data(Object data) {
            this.data = data;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "Message.MessageBuilder(errcode=" + this.errcode + ", errmsg=" + this.errmsg + ", data=" + String.valueOf(this.data) + ")";
        }
    }

    private static final class MessageBuilderImpl
    extends MessageBuilder<Message, MessageBuilderImpl> {
        private MessageBuilderImpl() {
        }

        @Override
        protected MessageBuilderImpl self() {
            return this;
        }

        @Override
        public Message build() {
            return new Message(this);
        }
    }
}

