/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.basics.entity;

import java.util.Collections;
import java.util.List;

public class Result<T> {
    private static final long serialVersionUID = 1L;
    protected long total;
    protected List<T> rows;
    protected transient Integer pageNo;
    protected transient Integer pageSize;

    public List<T> get(int pageNo) {
        int fromIndex = (pageNo - 1) * this.pageSize;
        if (fromIndex >= this.rows.size()) {
            return Collections.emptyList();
        }
        int toIndex = pageNo * this.pageSize;
        if (toIndex >= this.rows.size()) {
            toIndex = this.rows.size();
        }
        return this.rows.subList(fromIndex, toIndex);
    }

    protected Result(ResultBuilder<T, ?, ?> b) {
        this.total = b.total;
        this.rows = b.rows;
        this.pageNo = b.pageNo;
        this.pageSize = b.pageSize;
    }

    public static <T> ResultBuilder<T, ?, ?> builder() {
        return new ResultBuilderImpl();
    }

    public long getTotal() {
        return this.total;
    }

    public List<T> getRows() {
        return this.rows;
    }

    public Integer getPageNo() {
        return this.pageNo;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public void setRows(List<T> rows) {
        this.rows = rows;
    }

    public void setPageNo(Integer pageNo) {
        this.pageNo = pageNo;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Result() {
    }

    public Result(long total, List<T> rows, Integer pageNo, Integer pageSize) {
        this.total = total;
        this.rows = rows;
        this.pageNo = pageNo;
        this.pageSize = pageSize;
    }

    public static abstract class ResultBuilder<T, C extends Result<T>, B extends ResultBuilder<T, C, B>> {
        private long total;
        private List<T> rows;
        private Integer pageNo;
        private Integer pageSize;

        public B total(long total) {
            this.total = total;
            return this.self();
        }

        public B rows(List<T> rows) {
            this.rows = rows;
            return this.self();
        }

        public B pageNo(Integer pageNo) {
            this.pageNo = pageNo;
            return this.self();
        }

        public B pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "Result.ResultBuilder(total=" + this.total + ", rows=" + String.valueOf(this.rows) + ", pageNo=" + this.pageNo + ", pageSize=" + this.pageSize + ")";
        }
    }

    private static final class ResultBuilderImpl<T>
    extends ResultBuilder<T, Result<T>, ResultBuilderImpl<T>> {
        private ResultBuilderImpl() {
        }

        @Override
        protected ResultBuilderImpl<T> self() {
            return this;
        }

        @Override
        public Result<T> build() {
            return new Result(this);
        }
    }
}

