/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.cache;

import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.core.xyz.ThreadKit;

public enum GlobalPruneTimer {
    INSTANCE;

    private final AtomicInteger cacheTaskNumber = new AtomicInteger(1);
    private ScheduledExecutorService pruneTimer;

    private GlobalPruneTimer() {
        this.init();
    }

    public ScheduledFuture<?> schedule(Runnable task, long delay) {
        return this.pruneTimer.scheduleAtFixedRate(task, delay, delay, TimeUnit.MILLISECONDS);
    }

    public void init() {
        if (null != this.pruneTimer) {
            this.shutdownNow();
        }
        this.pruneTimer = new ScheduledThreadPoolExecutor(1, r -> ThreadKit.newThread(r, StringKit.format("Pure-Timer-{}", this.cacheTaskNumber.getAndIncrement())));
    }

    public void shutdown() {
        if (null != this.pruneTimer) {
            this.pruneTimer.shutdown();
        }
    }

    public List<Runnable> shutdownNow() {
        if (null != this.pruneTimer) {
            return this.pruneTimer.shutdownNow();
        }
        return null;
    }
}

