/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.date.culture.solar;

import java.util.ArrayList;
import java.util.List;
import org.miaixz.bus.core.center.date.culture.Loops;
import org.miaixz.bus.core.center.date.culture.en.Quarter;
import org.miaixz.bus.core.center.date.culture.solar.SolarMonth;
import org.miaixz.bus.core.center.date.culture.solar.SolarYear;

public class SolarQuarter
extends Loops {
    protected SolarYear year;
    protected int index;

    public SolarQuarter(int year, int index) {
        if (index < 0 || index > 3) {
            throw new IllegalArgumentException(String.format("illegal solar season index: %d", index));
        }
        this.year = SolarYear.fromYear(year);
        this.index = index;
    }

    public static SolarQuarter fromIndex(int year, int index) {
        return new SolarQuarter(year, index);
    }

    public SolarYear getYear() {
        return this.year;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public String getName() {
        return Quarter.getName(this.index);
    }

    @Override
    public String toString() {
        return String.valueOf(this.year) + this.getName();
    }

    @Override
    public SolarQuarter next(int n) {
        if (n == 0) {
            return SolarQuarter.fromIndex(this.year.getYear(), this.index);
        }
        int i = this.index + n;
        int y = this.year.getYear() + i / 4;
        if ((i %= 4) < 0) {
            i += 4;
            --y;
        }
        return SolarQuarter.fromIndex(y, i);
    }

    public List<SolarMonth> getMonths() {
        ArrayList<SolarMonth> l = new ArrayList<SolarMonth>(3);
        int y = this.year.getYear();
        for (int i = 0; i < 3; ++i) {
            l.add(SolarMonth.fromYm(y, this.index * 3 + i + 1));
        }
        return l;
    }
}

