/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.date.format.parser;

import java.io.Serializable;
import org.miaixz.bus.core.center.date.DateTime;
import org.miaixz.bus.core.center.date.Formatter;
import org.miaixz.bus.core.center.date.format.parser.PredicateDateParser;
import org.miaixz.bus.core.lang.exception.DateException;
import org.miaixz.bus.core.xyz.PatternKit;
import org.miaixz.bus.core.xyz.StringKit;

public class ISO8601DateParser
implements PredicateDateParser,
Serializable {
    private static final long serialVersionUID = -1L;
    public static ISO8601DateParser INSTANCE = new ISO8601DateParser();

    private static String normalizeMillSeconds(CharSequence date, CharSequence before, CharSequence after) {
        if (StringKit.isBlank(after)) {
            String millOrNaco = StringKit.subPre(StringKit.subAfter(date, before, true), 3);
            return StringKit.subBefore(date, before, true) + String.valueOf(before) + millOrNaco;
        }
        String millOrNaco = StringKit.subPre(StringKit.subBetween(date, before, after), 3);
        return StringKit.subBefore(date, before, true) + String.valueOf(before) + millOrNaco + String.valueOf(after) + StringKit.subAfter(date, after, true);
    }

    @Override
    public boolean test(CharSequence date) {
        return StringKit.contains(date, 'T');
    }

    @Override
    public DateTime parse(CharSequence source) throws DateException {
        int length = source.length();
        if (StringKit.contains((CharSequence)source, 'Z')) {
            if (length == "yyyy-MM-dd'T'HH:mm:ss'Z'".length() - 4) {
                return new DateTime((CharSequence)source, Formatter.UTC_FORMAT);
            }
            int patternLength = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'".length();
            if (length <= patternLength && length >= patternLength - 6) {
                return new DateTime((CharSequence)source, Formatter.UTC_MS_FORMAT);
            }
        } else {
            if (StringKit.contains((CharSequence)source, '+')) {
                String zoneOffset = StringKit.subAfter((CharSequence)(source = StringKit.replace((CharSequence)source, (CharSequence)" +", "+")), '+', true);
                if (StringKit.isBlank(zoneOffset)) {
                    throw new DateException("Invalid format: [{}]", source);
                }
                if (!StringKit.contains((CharSequence)zoneOffset, ':')) {
                    String pre = StringKit.subBefore((CharSequence)source, '+', true);
                    source = pre + "+" + zoneOffset.substring(0, 2) + ":00";
                }
                if (StringKit.contains((CharSequence)source, '.')) {
                    source = ISO8601DateParser.normalizeMillSeconds((CharSequence)source, ".", "+");
                    return new DateTime((CharSequence)source, Formatter.ISO8601_MS_WITH_XXX_OFFSET_FORMAT);
                }
                return new DateTime((CharSequence)source, Formatter.ISO8601_WITH_XXX_OFFSET_FORMAT);
            }
            if (PatternKit.contains("-\\d{2}:?00", (CharSequence)source)) {
                if (':' != (source = StringKit.replace((CharSequence)source, (CharSequence)" -", "-")).charAt(source.length() - 3)) {
                    source = StringKit.sub((CharSequence)source, 0, source.length() - 2) + ":00";
                }
                if (StringKit.contains((CharSequence)source, '.')) {
                    source = ISO8601DateParser.normalizeMillSeconds((CharSequence)source, ".", "-");
                    return new DateTime((CharSequence)source, Formatter.ISO8601_MS_WITH_XXX_OFFSET_FORMAT);
                }
                return new DateTime((CharSequence)source, Formatter.ISO8601_WITH_XXX_OFFSET_FORMAT);
            }
            if (length == "yyyy-MM-dd'T'HH:mm:ss".length() - 2) {
                return new DateTime((CharSequence)source, Formatter.ISO8601_FORMAT);
            }
            if (length == "yyyy-MM-dd'T'HH:mm:ss".length() - 5) {
                return new DateTime((CharSequence)(String.valueOf(source) + ":00"), Formatter.ISO8601_FORMAT);
            }
            if (StringKit.contains((CharSequence)source, '.')) {
                source = ISO8601DateParser.normalizeMillSeconds((CharSequence)source, ".", null);
                return new DateTime((CharSequence)source, Formatter.ISO8601_MS_FORMAT);
            }
        }
        throw new DateException("No UTC format fit for date String [{}] !", source);
    }
}

